/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.service;

import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.CompleteMultipartUploadResult;
import org.mule.extension.s3.api.model.CopyPartResult;
import org.mule.extension.s3.api.model.MultipartUploadListing;
import org.mule.extension.s3.api.model.PartListing;
import org.mule.extension.s3.api.model.UploadPartResult;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.operation.S3ModelFactory;
import org.mule.extension.s3.internal.parser.ObjectMetadataParser;
import org.mule.extension.s3.internal.parser.ObjectParser;
import org.mule.extension.s3.internal.service.ObjectIdentifier;
import org.mule.extension.s3.internal.service.UploadService;
import org.mule.extension.s3.internal.service.VersionedObjectIdentifier;
import org.mule.extension.s3.internal.util.DateUtils;

public class UploadServiceImpl
extends DefaultConnectorService<S3Configuration, S3Connection>
implements UploadService {
    private final ObjectParser<ObjectMetadataParameterGroup, ObjectMetadata> objectMetadataParser = new ObjectMetadataParser();

    public UploadServiceImpl(S3Configuration config, S3Connection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public String initiateMultipartUpload(ObjectIdentifier objectId, ObjectMetadataParameterGroup objectMetadata, CannedAccessControlList acl, String redirectLocation) {
        InitiateMultipartUploadRequest uploadRequest = new InitiateMultipartUploadRequest(objectId.getBucketName(), objectId.getKey());
        uploadRequest.setCannedACL(com.amazonaws.services.s3.model.CannedAccessControlList.valueOf((String)acl.toString()));
        Optional.ofNullable(objectMetadata).map(ObjectMetadataParameterGroup::getStorageClass).filter(Objects::nonNull).map(Object::toString).map(StorageClass::fromValue).ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)uploadRequest).setStorageClass(arg_0));
        Optional.ofNullable(objectMetadata).map(this.objectMetadataParser::to).ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)uploadRequest).setObjectMetadata(arg_0));
        uploadRequest.setRedirectLocation(redirectLocation);
        return ((S3Connection)this.getConnection()).initiateMultipartUpload(uploadRequest).getUploadId();
    }

    @Override
    public UploadPartResult uploadPart(VersionedObjectIdentifier objectId, Integer partNumber, Long partSize, String md5Digest, InputStream content, Long fileOffset, boolean isLastPart) {
        UploadPartRequest uploadPart = new UploadPartRequest().withBucketName(objectId.getBucketName()).withKey(objectId.getKey()).withUploadId(objectId.getVersionId()).withPartNumber(partNumber.intValue()).withInputStream(content).withLastPart(isLastPart).withMD5Digest(md5Digest);
        if (fileOffset != null) {
            uploadPart.setFileOffset(fileOffset.longValue());
        }
        if (partSize != null) {
            uploadPart.setPartSize(partSize.longValue());
        }
        return S3ModelFactory.wrapUploadPartResult(((S3Connection)this.getConnection()).uploadPart(uploadPart));
    }

    @Override
    public CopyPartResult uploadPartCopy(VersionedObjectIdentifier sourceObjectId, VersionedObjectIdentifier destinationObjectId, Integer partNumber, List<String> matchingETagConstraints, LocalDateTime modifiedSince, LocalDateTime unmodifiedSince, Long firstByte, Long lastByte) {
        CopyPartRequest copyPart = new CopyPartRequest().withSourceBucketName(sourceObjectId.getBucketName()).withSourceKey(sourceObjectId.getKey()).withSourceVersionId(sourceObjectId.getVersionId()).withDestinationBucketName(destinationObjectId.getBucketName()).withDestinationKey(destinationObjectId.getKey()).withUploadId(destinationObjectId.getVersionId()).withPartNumber(partNumber.intValue()).withFirstByte(firstByte).withLastByte(lastByte).withModifiedSinceConstraint(DateUtils.toDate(modifiedSince)).withUnmodifiedSinceConstraint(DateUtils.toDate(unmodifiedSince));
        if (matchingETagConstraints != null && !matchingETagConstraints.isEmpty()) {
            copyPart.setMatchingETagConstraints(matchingETagConstraints);
        }
        return S3ModelFactory.wrapCopyPartResult(((S3Connection)this.getConnection()).copyPart(copyPart));
    }

    @Override
    public void abortMultipartUpload(VersionedObjectIdentifier objectId) {
        ((S3Connection)this.getConnection()).abortMultipartUpload(new AbortMultipartUploadRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId()));
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(VersionedObjectIdentifier objectId, List<org.mule.extension.s3.api.model.PartETag> partETags) {
        ArrayList<PartETag> eTags = new ArrayList<PartETag>(partETags.size());
        for (org.mule.extension.s3.api.model.PartETag tag : partETags) {
            eTags.add(new PartETag(tag.getPartNumber(), tag.getEtag()));
        }
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId(), eTags);
        return S3ModelFactory.wrapCompleteMultipartUploadResult(((S3Connection)this.getConnection()).completeMultipartUpload(completeRequest));
    }

    @Override
    public MultipartUploadListing listMultipartUploads(String bucketName, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucketName).withDelimiter(delimiter).withEncodingType(encodingType).withKeyMarker(keyMarker).withPrefix(prefix).withUploadIdMarker(uploadIdMarker);
        if (maxUploads != null) {
            listRequest.setMaxUploads(maxUploads);
        }
        return S3ModelFactory.wrapMultipartUploadListing(((S3Connection)this.getConnection()).listMultipartUploads(listRequest));
    }

    @Override
    public PartListing listParts(VersionedObjectIdentifier objectId, String encodingType, Integer maxParts, Integer partNumberMarker) {
        ListPartsRequest listParts = new ListPartsRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId());
        listParts.setEncodingType(encodingType);
        if (maxParts != null) {
            listParts.setMaxParts(maxParts.intValue());
        }
        listParts.setPartNumberMarker(partNumberMarker);
        return S3ModelFactory.wrapPartListing(((S3Connection)this.getConnection()).listParts(listParts));
    }
}

