/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.service.bucket;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.s3.model.VersionListing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.model.BLCRule;
import org.mule.extension.s3.api.model.Bucket;
import org.mule.extension.s3.api.model.BucketLoggingConfiguration;
import org.mule.extension.s3.api.model.CORSRule;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.Region;
import org.mule.extension.s3.api.model.TopicConfiguration;
import org.mule.extension.s3.api.model.VersioningStatus;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.operation.S3ModelFactory;
import org.mule.extension.s3.internal.service.bucket.BucketService;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class BucketServiceImpl
extends DefaultConnectorService<S3Configuration, S3Connection>
implements BucketService {
    public BucketServiceImpl(S3Configuration config, S3Connection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public Bucket createBucket(String bucketName, String region, CannedAccessControlList acl) {
        String awsRegion = this.getAwsRegion(region);
        awsRegion = awsRegion == null ? Region.US_STANDARD.toString() : awsRegion;
        return S3ModelFactory.wrapBucket(((S3Connection)this.getConnection()).createBucket(new CreateBucketRequest(bucketName, awsRegion.equalsIgnoreCase(Region.US_STANDARD.toString()) ? null : awsRegion.toLowerCase()).withCannedAcl(com.amazonaws.services.s3.model.CannedAccessControlList.valueOf((String)acl.toString()))));
    }

    @Override
    public void deleteBucket(String bucketName, boolean force) {
        if (force) {
            this.delete(((S3Connection)this.getConnection()).listObjects(bucketName));
            this.delete(((S3Connection)this.getConnection()).listVersions(new ListVersionsRequest().withBucketName(bucketName)));
        }
        ((S3Connection)this.getConnection()).deleteBucket(bucketName);
    }

    private void delete(ObjectListing listing) {
        listing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).forEach(key -> ((S3Connection)this.getConnection()).deleteObject(listing.getBucketName(), (String)key));
        Optional.of(listing).filter(ObjectListing::isTruncated).map(((S3Connection)this.getConnection())::listNextBatchOfObjects).ifPresent(this::delete);
    }

    private void delete(VersionListing listing) {
        listing.getVersionSummaries().forEach(summary -> ((S3Connection)this.getConnection()).deleteVersion(listing.getBucketName(), summary.getKey(), summary.getVersionId()));
        Optional.of(listing).filter(VersionListing::isTruncated).map(((S3Connection)this.getConnection())::listNextBatchOfVersions).ifPresent(this::delete);
    }

    @Override
    public List<Bucket> listBuckets(String region) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        String awsRegion = this.getAwsRegion(region);
        if (awsRegion == null) {
            List<com.amazonaws.services.s3.model.Bucket> responseBuckets = ((S3Connection)this.getConnection()).listBuckets();
            for (com.amazonaws.services.s3.model.Bucket bucket : responseBuckets) {
                buckets.add(S3ModelFactory.wrapBucket(bucket));
            }
        } else {
            List<com.amazonaws.services.s3.model.Bucket> responseBuckets = ((S3Connection)this.getConnection()).listBuckets();
            for (com.amazonaws.services.s3.model.Bucket bucket : responseBuckets) {
                this.getBucketsByRegion(buckets, awsRegion, bucket);
            }
        }
        return buckets;
    }

    private void getBucketsByRegion(List<Bucket> buckets, String awsRegion, com.amazonaws.services.s3.model.Bucket bucket) {
        block3: {
            try {
                String bucketLocation = this.getBucketLocation(bucket.getName());
                if (awsRegion.equals(bucketLocation)) {
                    buckets.add(S3ModelFactory.wrapBucket(bucket));
                }
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404) break block3;
                throw e;
            }
        }
    }

    private String getAwsRegion(String region) {
        try {
            return Region.valueOf(region).toString();
        }
        catch (IllegalArgumentException e) {
            String awsRegion = region.toLowerCase().replace("_", "-");
            return awsRegion.equalsIgnoreCase("us-east-1") ? "US" : awsRegion;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getBucketLocation(String bucketName) {
        return ((S3Connection)this.getConnection()).getBucketLocation(bucketName);
    }

    @Override
    public String getBucketPolicy(String bucketName) {
        return ((S3Connection)this.getConnection()).getBucketPolicy(bucketName).getPolicyText();
    }

    @Override
    public void deleteBucketPolicy(String bucketName) {
        ((S3Connection)this.getConnection()).deleteBucketPolicy(bucketName);
    }

    @Override
    public void setBucketPolicy(String bucketName, String policyText) {
        ((S3Connection)this.getConnection()).setBucketPolicy(bucketName, policyText);
    }

    @Override
    public Result<List<Grant>, AccessControlListAttributes> getBucketAcl(String bucketName) {
        return S3ModelFactory.wrapAccessControlList(((S3Connection)this.getConnection()).getBucketAcl(bucketName));
    }

    @Override
    public void setBucketAcl(String bucketName, Owner owner, List<Grant> grants) {
        ((S3Connection)this.getConnection()).setBucketAcl(bucketName, S3ModelFactory.unwrapAccessControlList(owner, grants));
    }

    @Override
    public List<CORSRule> getBucketCorsConfiguration(String bucketName) {
        return Optional.ofNullable(((S3Connection)this.getConnection()).getBucketCrossOriginConfiguration(bucketName)).map(BucketCrossOriginConfiguration::getRules).map(S3ModelFactory::wrapBucketCrossOriginConfigurationRules).orElseGet(ArrayList::new);
    }

    @Override
    public void setBucketCorsConfiguration(String bucketName, List<CORSRule> rules) {
        ((S3Connection)this.getConnection()).setBucketCrossOriginConfiguration(bucketName, new BucketCrossOriginConfiguration(S3ModelFactory.unwrapBucketCrossOriginConfigurationRules(rules)));
    }

    @Override
    public void deleteBucketCorsConfiguration(String bucketName) {
        ((S3Connection)this.getConnection()).deleteBucketCrossOriginConfiguration(bucketName);
    }

    @Override
    public List<BLCRule> getBucketLifecycleConfiguration(String bucketName) {
        BucketLifecycleConfiguration configuration = ((S3Connection)this.getConnection()).getBucketLifecycleConfiguration(bucketName);
        if (configuration == null || configuration.getRules().isEmpty()) {
            return Collections.emptyList();
        }
        return S3ModelFactory.wrapBucketLifecycleRules(configuration.getRules());
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, List<BLCRule> lifecycleConfigurationRules) {
        Validate.notEmpty(lifecycleConfigurationRules, (String)"The LifecycleConfiguration Rules parameter must be specified when setting a bucket's lifeycle");
        List<BucketLifecycleConfiguration.Rule> blcRules = S3ModelFactory.unwrapBucketLifecycleConfigurationRules(lifecycleConfigurationRules);
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration().withRules(blcRules);
        ((S3Connection)this.getConnection()).setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) {
        ((S3Connection)this.getConnection()).deleteBucketLifecycleConfiguration(bucketName);
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) {
        com.amazonaws.services.s3.model.BucketLoggingConfiguration conf = ((S3Connection)this.getConnection()).getBucketLoggingConfiguration(bucketName);
        return new BucketLoggingConfiguration(conf.getDestinationBucketName(), conf.getLogFilePrefix());
    }

    @Override
    public void setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration bucketLoggingConfiguration) {
        ((S3Connection)this.getConnection()).setBucketLoggingConfiguration(new SetBucketLoggingConfigurationRequest(bucketName, new com.amazonaws.services.s3.model.BucketLoggingConfiguration(bucketLoggingConfiguration.getDestinationBucketName(), bucketLoggingConfiguration.getLogFilePrefix())));
    }

    @Override
    public Map<String, TopicConfiguration> getBucketNotificationConfiguration(String bucketName) {
        return S3ModelFactory.wrapBucketNotification(((S3Connection)this.getConnection()).getBucketNotificationConfiguration(bucketName));
    }

    @Override
    public void setBucketNotificationConfiguration(String bucketName, Map<String, TopicConfiguration> topicConfigurations) {
        ((S3Connection)this.getConnection()).setBucketNotificationConfiguration(bucketName, S3ModelFactory.unwrapBucketNotification(topicConfigurations));
    }

    @Override
    public List<Map<String, String>> getBucketTaggingConfiguration(String bucketName) {
        return Optional.ofNullable(((S3Connection)this.getConnection()).getBucketTaggingConfiguration(bucketName)).map(BucketTaggingConfiguration::getAllTagSets).orElseGet(ArrayList::new).stream().map(TagSet::getAllTags).collect(Collectors.toList());
    }

    @Override
    public void setBucketTaggingConfiguration(String bucketName, List<Map<String, String>> tagSets) {
        ((S3Connection)this.getConnection()).setBucketTaggingConfiguration(bucketName, new BucketTaggingConfiguration((Collection)tagSets.stream().map(TagSet::new).collect(Collectors.toList())));
    }

    @Override
    public void deleteBucketTaggingConfiguration(String bucketName) {
        ((S3Connection)this.getConnection()).deleteBucketTaggingConfiguration(bucketName);
    }

    @Override
    public VersioningStatus getBucketVersioningConfiguration(String bucketName) {
        return VersioningStatus.valueOf(((S3Connection)this.getConnection()).getBucketVersioningConfiguration(bucketName).getStatus().toUpperCase());
    }

    @Override
    public void setBucketVersioningConfiguration(String bucketName, VersioningStatus versioningStatus) {
        ((S3Connection)this.getConnection()).setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(bucketName, new BucketVersioningConfiguration().withStatus(versioningStatus.toString())));
    }

    @Override
    public org.mule.extension.s3.api.model.BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) {
        BucketWebsiteConfiguration configuration = ((S3Connection)this.getConnection()).getBucketWebsiteConfiguration(bucketName);
        return S3ModelFactory.wrapBucketWebsiteConfiguration(configuration);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String bucketName) {
        ((S3Connection)this.getConnection()).deleteBucketWebsiteConfiguration(bucketName);
    }

    @Override
    public void setBucketWebsiteConfiguration(String bucketName, org.mule.extension.s3.api.model.BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        Validate.notNull((Object)bucketWebsiteConfiguration, (String)"The BucketWebsiteConfiguration parameter must be specified when setting a bucket's website configuration");
        ((S3Connection)this.getConnection()).setBucketWebsiteConfiguration(bucketName, S3ModelFactory.unwrapBucketWebsiteConfiguration(bucketWebsiteConfiguration));
    }
}

