/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.api.group;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import org.mule.extension.s3.api.model.StorageClass;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ObjectMetadataParameterGroup
implements Serializable {
    @NullSafe
    @Optional
    @Parameter
    private Map<String, String> userMetadata;
    @Optional
    @Parameter
    private LocalDateTime lastModified;
    @Optional(defaultValue="0")
    @Parameter
    @Summary(value="The Content-Length HTTP header indicating the size of the associated object in bytes.")
    @Example(value="3495")
    private Long contentLength;
    @Optional
    @Parameter
    @Summary(value="The Content-Type HTTP header indicating the type of content stored in the associated object.")
    @Example(value="text/html; charset=ISO-8859-4")
    private String contentType;
    @Optional
    @Parameter
    @Summary(value="The Content-Language HTTP header which describes the natural language(s) of the intended audience for the enclosed entity.")
    @Example(value="en")
    private String contentLanguage;
    @Optional
    @Parameter
    @Summary(value="The optional Content-Encoding HTTP header specifying what content encodings have been applied to the object and what decoding mechanisms must be applied in order to obtain the media-type referenced by the Content-Type field.")
    @Example(value="gzip")
    private String contentEncoding;
    @Optional
    @Parameter
    @Summary(value="The optional Cache-Control HTTP header which allows the user to specify caching behavior along the HTTP request/reply chain.")
    @Example(value="public, max-age=31536000")
    private String cacheControl;
    @Optional
    @Parameter
    @Summary(value="The base64 encoded 128-bit MD5 digest of the associated object (content - not including headers) according to RFC 1864.")
    @Example(value="md5-digest")
    private String contentMD5;
    @Optional
    @Parameter
    @Summary(value="The optional Content-Disposition HTTP header, which specifies presentational information such as the recommended filename for the object to be saved as.")
    @Example(value="attachment")
    private String contentDisposition;
    @Optional
    @Parameter
    @Summary(value="The entity tag is a hash of the object.")
    @Example(value="xyzzy")
    private String etag;
    @Optional
    @Parameter
    @Summary(value="The version ID of the associated Amazon S3 object if available.")
    @Example(value="111111")
    private String versionId;
    @Optional
    @Parameter
    @Summary(value="Specifies the server-side encryption algorithm to use when Amazon S3 creates an object.")
    @Example(value="aws:kms")
    private String sseAlgorithm;
    @Optional
    @Parameter
    @Summary(value="Specifies the algorithm to use to when encrypting the object.")
    @Example(value="AES256")
    private String sseCustomerAlgorithm;
    @Optional
    @Parameter
    @Summary(value="Specifies the base64-encoded 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.")
    @Example(value="base64-encoded_128-bit_MD5_digest_of_the_encryption_key")
    private String sseCustomerKeyMd5;
    @Optional
    @Parameter
    @Summary(value="The expiration time for the object.")
    private LocalDateTime expirationTime;
    @Optional
    @Parameter
    @Summary(value="The rule ID of object's expiration configuration.")
    @Example(value="This_is_expiration_time_rule_id")
    private String expirationTimeRuleId;
    @Optional
    @Parameter
    @Summary(value="The new restore expiration time for the object.")
    private LocalDateTime restoreExpirationTime;
    @Optional(defaultValue="false")
    @Parameter
    @Summary(value="Sets the boolean value which indicates whether there is ongoing restore request.")
    @Example(value="false")
    private boolean ongoingRestore;
    @Optional
    @Parameter
    @Summary(value="Set the date when the object is no longer cacheable.")
    private LocalDateTime httpExpiresDate;
    @Optional(defaultValue="STANDARD")
    @Parameter
    @Summary(value="The storage class of the object.")
    private StorageClass storageClass;
    @Optional
    @Parameter
    @Summary(value="the AWS Key Management System key id used for Server Side Encryption of the Amazon S3 object.")
    @Example(value="testkey")
    private String sseAwsKmsKeyId;
    @Optional(defaultValue="false")
    @Parameter
    @Summary(value="If a bucket is enabled for Requester Pays, then any attempt of operation from it without Requester Pays enabled will result in a 403 error and the bucket owner will be charged for the request. Enabling Requester Pays disables the ability to have anonymous access to bucket.")
    @Example(value="false")
    private boolean requesterCharged;
    @Optional
    @Parameter
    @Summary(value="The replication status of the object if it is from a bucket that is the source or destination in a cross-region replication.")
    @Example(value="COMPLETED")
    private String replicationStatus;

    public ObjectMetadataParameterGroup() {
    }

    public ObjectMetadataParameterGroup(Map<String, String> userMetadata, LocalDateTime lastModified, Long contentLength, String contentType, String contentLanguage, String contentEncoding, String cacheControl, String contentMD5, String contentDisposition, String etag, String versionId, String sseAlgorithm, String sseCustomerAlgorithm, String sseCustomerKeyMd5, LocalDateTime expirationTime, String expirationTimeRuleId, LocalDateTime restoreExpirationTime, boolean ongoingRestore, LocalDateTime httpExpiresDate, StorageClass storageClass, String sseAwsKmsKeyId, boolean requesterCharged, String replicationStatus) {
        this.userMetadata = userMetadata;
        this.lastModified = lastModified;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentLanguage = contentLanguage;
        this.contentEncoding = contentEncoding;
        this.cacheControl = cacheControl;
        this.contentMD5 = contentMD5;
        this.contentDisposition = contentDisposition;
        this.etag = etag;
        this.versionId = versionId;
        this.sseAlgorithm = sseAlgorithm;
        this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        this.sseCustomerKeyMd5 = sseCustomerKeyMd5;
        this.expirationTime = expirationTime;
        this.expirationTimeRuleId = expirationTimeRuleId;
        this.restoreExpirationTime = restoreExpirationTime;
        this.ongoingRestore = ongoingRestore;
        this.httpExpiresDate = httpExpiresDate;
        this.storageClass = storageClass;
        this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        this.requesterCharged = requesterCharged;
        this.replicationStatus = replicationStatus;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public String getSseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String getSseCustomerKeyMd5() {
        return this.sseCustomerKeyMd5;
    }

    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    public LocalDateTime getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public boolean isOngoingRestore() {
        return this.ongoingRestore;
    }

    public LocalDateTime getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public String getSseAwsKmsKeyId() {
        return this.sseAwsKmsKeyId;
    }

    public boolean isRequesterCharged() {
        return this.requesterCharged;
    }

    public String getReplicationStatus() {
        return this.replicationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetadataParameterGroup that = (ObjectMetadataParameterGroup)o;
        return this.ongoingRestore == that.ongoingRestore && this.requesterCharged == that.requesterCharged && Objects.equals(this.userMetadata, that.userMetadata) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.contentLength, that.contentLength) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.contentLanguage, that.contentLanguage) && Objects.equals(this.contentEncoding, that.contentEncoding) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals(this.contentMD5, that.contentMD5) && Objects.equals(this.contentDisposition, that.contentDisposition) && Objects.equals(this.etag, that.etag) && Objects.equals(this.versionId, that.versionId) && Objects.equals(this.sseAlgorithm, that.sseAlgorithm) && Objects.equals(this.sseCustomerAlgorithm, that.sseCustomerAlgorithm) && Objects.equals(this.sseCustomerKeyMd5, that.sseCustomerKeyMd5) && Objects.equals(this.expirationTime, that.expirationTime) && Objects.equals(this.expirationTimeRuleId, that.expirationTimeRuleId) && Objects.equals(this.restoreExpirationTime, that.restoreExpirationTime) && Objects.equals(this.httpExpiresDate, that.httpExpiresDate) && this.storageClass == that.storageClass && Objects.equals(this.sseAwsKmsKeyId, that.sseAwsKmsKeyId) && Objects.equals(this.replicationStatus, that.replicationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userMetadata, this.lastModified, this.contentLength, this.contentType, this.contentLanguage, this.contentEncoding, this.cacheControl, this.contentMD5, this.contentDisposition, this.etag, this.versionId, this.sseAlgorithm, this.sseCustomerAlgorithm, this.sseCustomerKeyMd5, this.expirationTime, this.expirationTimeRuleId, this.restoreExpirationTime, this.ongoingRestore, this.httpExpiresDate, this.storageClass, this.sseAwsKmsKeyId, this.requesterCharged, this.replicationStatus});
    }
}

