/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.extension.s3.api.model.AllowedMethods;

public class CORSRule
implements Serializable {
    private static final long serialVersionUID = 6653330903388159693L;
    private String id;
    private List<AllowedMethods> allowedMethods = new ArrayList<AllowedMethods>(0);
    private List<String> allowedOrigins = new ArrayList<String>(0);
    private int maxAgeSeconds;
    private List<String> exposedHeaders = new ArrayList<String>(0);
    private List<String> allowedHeaders = new ArrayList<String>(0);

    public CORSRule() {
    }

    public CORSRule(String id, List<AllowedMethods> allowedMethods, List<String> allowedOrigins, int maxAgeSeconds, List<String> exposedHeaders, List<String> allowedHeaders) {
        this.id = id;
        this.allowedMethods = allowedMethods;
        this.allowedOrigins = allowedOrigins;
        this.maxAgeSeconds = maxAgeSeconds;
        this.exposedHeaders = exposedHeaders;
        this.allowedHeaders = allowedHeaders;
    }

    public String getId() {
        return this.id;
    }

    public List<AllowedMethods> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CORSRule corsRule = (CORSRule)o;
        return this.maxAgeSeconds == corsRule.maxAgeSeconds && Objects.equals(this.id, corsRule.id) && Objects.equals(this.allowedMethods, corsRule.allowedMethods) && Objects.equals(this.allowedOrigins, corsRule.allowedOrigins) && Objects.equals(this.exposedHeaders, corsRule.exposedHeaders) && Objects.equals(this.allowedHeaders, corsRule.allowedHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.allowedMethods, this.allowedOrigins, this.maxAgeSeconds, this.exposedHeaders, this.allowedHeaders);
    }
}

