/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.connection;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;

public class S3Connection
extends AWSConnection<AmazonS3, AmazonSQSAsync> {
    public S3Connection(AmazonS3 awsClient, AmazonSQSAsync asyncClient) {
        super((Object)awsClient, (Object)asyncClient);
    }

    public void validate() throws AWSConnectionException {
        ((AmazonS3)this.getAwsClient()).listBuckets();
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) {
        return ((AmazonS3)this.getAwsClient()).listObjects(listObjectsRequest);
    }

    public ObjectListing listObjects(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).listObjects(bucketName);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) {
        return ((AmazonS3)this.getAwsClient()).listNextBatchOfObjects(previousObjectListing);
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) {
        return ((AmazonS3)this.getAwsClient()).listVersions(listVersionsRequest);
    }

    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) {
        return ((AmazonS3)this.getAwsClient()).listNextBatchOfVersions(previousVersionListing);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        return ((AmazonS3)this.getAwsClient()).putObject(putObjectRequest);
    }

    public void deleteVersion(String bucketName, String key, String versionId) {
        ((AmazonS3)this.getAwsClient()).deleteVersion(bucketName, key, versionId);
    }

    public S3Object getObject(GetObjectRequest getObjectRequest) {
        return ((AmazonS3)this.getAwsClient()).getObject(getObjectRequest);
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectRequest) {
        return ((AmazonS3)this.getAwsClient()).getObjectMetadata(getObjectRequest);
    }

    public void deleteObject(String bucketName, String key) {
        ((AmazonS3)this.getAwsClient()).deleteObject(bucketName, key);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        return ((AmazonS3)this.getAwsClient()).deleteObjects(deleteObjectsRequest);
    }

    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) {
        ((AmazonS3)this.getAwsClient()).setObjectAcl(bucketName, key, versionId, acl);
    }

    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) {
        return ((AmazonS3)this.getAwsClient()).getObjectAcl(bucketName, key, versionId);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) {
        return ((AmazonS3)this.getAwsClient()).generatePresignedUrl(generatePresignedUrlRequest);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) {
        return ((AmazonS3)this.getAwsClient()).copyObject(copyObjectRequest);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        return ((AmazonS3)this.getAwsClient()).initiateMultipartUpload(request);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) {
        return ((AmazonS3)this.getAwsClient()).uploadPart(request);
    }

    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return ((AmazonS3)this.getAwsClient()).copyPart(copyPartRequest);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) {
        ((AmazonS3)this.getAwsClient()).abortMultipartUpload(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return ((AmazonS3)this.getAwsClient()).completeMultipartUpload(request);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) {
        return ((AmazonS3)this.getAwsClient()).listMultipartUploads(request);
    }

    public PartListing listParts(ListPartsRequest request) {
        return ((AmazonS3)this.getAwsClient()).listParts(request);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) {
        return ((AmazonS3)this.getAwsClient()).createBucket(createBucketRequest);
    }

    public void deleteBucket(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucket(bucketName);
    }

    public List<Bucket> listBuckets() {
        return ((AmazonS3)this.getAwsClient()).listBuckets();
    }

    public String getBucketLocation(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketLocation(bucketName);
    }

    public BucketPolicy getBucketPolicy(String bucketPolicy) {
        return ((AmazonS3)this.getAwsClient()).getBucketPolicy(bucketPolicy);
    }

    public void deleteBucketPolicy(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucketPolicy(bucketName);
    }

    public void setBucketPolicy(String bucketName, String policyText) {
        ((AmazonS3)this.getAwsClient()).setBucketPolicy(bucketName, policyText);
    }

    public AccessControlList getBucketAcl(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketAcl(bucketName);
    }

    public void setBucketAcl(String bucketName, AccessControlList acl) {
        ((AmazonS3)this.getAwsClient()).setBucketAcl(bucketName, acl);
    }

    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketCrossOriginConfiguration(bucketName);
    }

    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        ((AmazonS3)this.getAwsClient()).setBucketCrossOriginConfiguration(bucketName, bucketCrossOriginConfiguration);
    }

    public void deleteBucketCrossOriginConfiguration(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucketCrossOriginConfiguration(bucketName);
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketLifecycleConfiguration(bucketName);
    }

    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        ((AmazonS3)this.getAwsClient()).setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
    }

    public void deleteBucketLifecycleConfiguration(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucketLifecycleConfiguration(bucketName);
    }

    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketLoggingConfiguration(bucketName);
    }

    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) {
        ((AmazonS3)this.getAwsClient()).setBucketLoggingConfiguration(setBucketLoggingConfigurationRequest);
    }

    public BucketNotificationConfiguration getBucketNotificationConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketNotificationConfiguration(bucketName);
    }

    public void setBucketNotificationConfiguration(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) {
        ((AmazonS3)this.getAwsClient()).setBucketNotificationConfiguration(bucketName, bucketNotificationConfiguration);
    }

    public BucketTaggingConfiguration getBucketTaggingConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketTaggingConfiguration(bucketName);
    }

    public void setBucketTaggingConfiguration(String bucketName, BucketTaggingConfiguration bucketTaggingConfiguration) {
        ((AmazonS3)this.getAwsClient()).setBucketTaggingConfiguration(bucketName, bucketTaggingConfiguration);
    }

    public void deleteBucketTaggingConfiguration(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucketTaggingConfiguration(bucketName);
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketVersioningConfiguration(bucketName);
    }

    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) {
        ((AmazonS3)this.getAwsClient()).setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
    }

    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) {
        return ((AmazonS3)this.getAwsClient()).getBucketWebsiteConfiguration(bucketName);
    }

    public void deleteBucketWebsiteConfiguration(String bucketName) {
        ((AmazonS3)this.getAwsClient()).deleteBucketWebsiteConfiguration(bucketName);
    }

    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) {
        ((AmazonS3)this.getAwsClient()).setBucketWebsiteConfiguration(bucketName, configuration);
    }

    public Owner getS3AccountOwner() {
        return ((AmazonS3)this.getAwsClient()).getS3AccountOwner();
    }

    public GetQueueUrlResult getQueueUrl(String queueName) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).getQueueUrl(queueName);
    }

    public CreateQueueResult createQueue(String queueName) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).createQueue(queueName);
    }

    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).setQueueAttributes(queueUrl, attributes);
    }

    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).getQueueAttributes(queueUrl, attributeNames);
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).receiveMessage(receiveMessageRequest);
    }

    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        return ((AmazonSQSAsync)this.getAwsAsyncClient()).deleteMessage(queueUrl, receiptHandle);
    }
}

