/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.connection.provider;

import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import org.mule.extension.s3.internal.config.group.AdditionalParameterGroup;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.connection.provider.ParentBasicConnectionProvider;
import org.mule.extension.s3.internal.util.ClientBuilderUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="basic")
public class BasicConnectionProvider
extends ParentBasicConnectionProvider<S3Connection> {
    @ParameterGroup(name="Advanced")
    @Placement(order=1)
    AdditionalParameterGroup additionalParameterGroup;

    public BasicConnectionProvider() {
        super(S3Connection::new);
    }

    protected void configureRegionProperty(AmazonS3ClientBuilder clientBuilder, AmazonSQSAsyncClientBuilder asyncClientBuilder) {
        ClientBuilderUtils.configureGlobalBucketAccess(clientBuilder, this.additionalParameterGroup.isForceGlobalBucketAccess());
        String region = this.getCommonParameters().getRegion().toLowerCase().replace("_", "-");
        String storageUrl = this.additionalParameterGroup.getStorageUrl();
        String customServiceEndpoint = this.getCommonParameters().getCustomServiceEndpoint();
        if (storageUrl != null && customServiceEndpoint == null) {
            ClientBuilderUtils.setEndpointConfiguration(clientBuilder, asyncClientBuilder, storageUrl, region);
        } else {
            super.configureRegionProperty((AwsClientBuilder)clientBuilder, (AwsAsyncClientBuilder)asyncClientBuilder);
        }
    }

    public void setAdditionalParameterGroup(AdditionalParameterGroup additionalParameterGroup) {
        this.additionalParameterGroup = additionalParameterGroup;
    }
}

