/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.attributes.S3ObjectAttributes;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.EncodingType;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.HttpMethod;
import org.mule.extension.s3.api.model.KeyVersion;
import org.mule.extension.s3.api.model.ObjectResult;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.api.model.S3VersionSummary;
import org.mule.extension.s3.api.model.SSEAlgorithm;
import org.mule.extension.s3.api.model.StorageClass;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.config.group.Range;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.error.provider.S3ErrorTypeProvider;
import org.mule.extension.s3.internal.operation.S3Operations;
import org.mule.extension.s3.internal.service.ObjectIdentifier;
import org.mule.extension.s3.internal.service.ObjectService;
import org.mule.extension.s3.internal.service.ObjectServiceImpl;
import org.mule.extension.s3.internal.service.VersionedObjectIdentifier;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

@Throws(value={S3ErrorTypeProvider.class})
public class ObjectOperations
extends S3Operations<ObjectService> {
    public ObjectOperations() {
        super(ObjectServiceImpl::new);
    }

    public ObjectResult createObject(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Summary(value="The content to be uploaded to S3, capable of creating a {@link PutObjectRequest}.") @Content InputStream objectContent, @Summary(value="The additional information about the new object being created, such as content type & encoding, etc.") @ParameterGroup(name="Metadata") ObjectMetadataParameterGroup objectMetadata, @DisplayName(value="Canned ACL") @Optional(defaultValue="PRIVATE") CannedAccessControlList acl, @Optional String kmsMasterKey) {
        return (ObjectResult)this.newExecutionBuilder(config, connection).execute(ObjectService::createObject).withParam((Object)new ObjectIdentifier(bucketName, key)).withParam((Object)objectContent).withParam((Object)objectMetadata).withParam((Object)acl).withParam((Object)kmsMasterKey);
    }

    public void deleteObject(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Optional String versionId) {
        this.newExecutionBuilder(config, connection).execute(ObjectService::deleteObject).withParam((Object)new VersionedObjectIdentifier(bucketName, key, versionId));
    }

    public void deleteObjects(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, List<KeyVersion> keys) {
        this.newExecutionBuilder(config, connection).execute(ObjectService::deleteObjects).withParam((Object)bucketName).withParam(keys);
    }

    public PagingProvider<S3Connection, S3ObjectSummary> listObjects(String bucketName, @Optional String prefix, @Summary(value="Where in the bucket to begin listing. The list will only include keys that occur lexicographically after the marker.") @Optional String marker, @Summary(value="Causes keys that contain the same string between a prefix and the first occurrence of the delimiter to be rolled up into a single result element.") @Optional String delimiter, @Summary(value="The maximum number of keys to return per page. If not specified S3 will limit the number of returned results per page.") @Optional Integer maxKeys, @Optional(defaultValue="NOT_ENCODED") EncodingType encodingType) {
        return (PagingProvider)this.newExecutionBuilder(null, null).execute(ObjectService::listObjects).withParam((Object)bucketName).withParam((Object)prefix).withParam((Object)marker).withParam((Object)delimiter).withParam((Object)maxKeys).withParam((Object)encodingType);
    }

    public void setObjectStorageClass(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Content @Optional(defaultValue="STANDARD") StorageClass storageClass) {
        this.newExecutionBuilder(config, connection).execute(ObjectService::setObjectStorageClass).withParam((Object)new ObjectIdentifier(bucketName, key)).withParam((Object)storageClass);
    }

    public void setObjectAcl(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Optional String versionId, Owner owner, @Content List<Grant> grants) {
        this.newExecutionBuilder(config, connection).execute(ObjectService::setObjectAcl).withParam((Object)new VersionedObjectIdentifier(bucketName, key, versionId)).withParam((Object)owner).withParam(grants);
    }

    public ObjectResult copyObject(@Config S3Configuration config, @Connection S3Connection connection, @Placement(order=1) String sourceBucketName, @Placement(order=2) String sourceKey, @Placement(order=3) @Summary(value="The specific version of the source object to copy, if versioning is enabled. ") @Optional String sourceVersionId, @Placement(order=4) @Summary(value="The destination object's bucket. If none provided, object is copied within the same bucket.") @Optional String destinationBucketName, @Placement(order=5) String destinationKey, @Placement(order=6) @DisplayName(value="Canned ACL") @Optional(defaultValue="PRIVATE") CannedAccessControlList destinationAcl, @Placement(order=7) @Summary(value="One of {@link StorageClass} enumerated values, defaults to {@link StorageClass#STANDARD}") @Optional(defaultValue="STANDARD") StorageClass destinationStorageClass, @Placement(order=8) @Summary(value="The new metadata of the destination object. If specified, overrides that copied from the source object") @Optional @NullSafe Map<String, String> destinationUserMetadata, @Placement(order=9) @Summary(value="The modified constraint that restricts this request to executing only if the object has been modified after the specified date. ") @Optional LocalDateTime modifiedSince, @Placement(order=10) @Summary(value="The unmodified constraint that restricts this request to executing only if the object has not been modified after this date. ") @Optional LocalDateTime unmodifiedSince, @Placement(order=11) @Optional String encryption, @Placement(order=12) @Optional String contentType) {
        return (ObjectResult)this.newExecutionBuilder(config, connection).execute(ObjectService::copyObject).withParam((Object)new VersionedObjectIdentifier(sourceBucketName, sourceKey, sourceVersionId)).withParam((Object)new ObjectIdentifier(destinationBucketName, destinationKey)).withParam((Object)destinationAcl).withParam((Object)destinationStorageClass).withParam(destinationUserMetadata).withParam((Object)modifiedSince).withParam((Object)unmodifiedSince).withParam((Object)encryption).withParam((Object)contentType);
    }

    @MediaType(value="text/plain")
    public String createObjectPresignedUri(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Summary(value="The expiration date at which point the new pre-signed URL will no longer be accepted by Amazon S3.") @Optional LocalDateTime expiration, @DisplayName(value="Content MD5") @Optional String contentMd5, @Optional String contentType, @Optional(defaultValue="PUT") HttpMethod method, @Optional SSEAlgorithm sseS3Encryption) {
        return (String)this.newExecutionBuilder(config, connection).execute(ObjectService::createObjectPresignedUri).withParam((Object)new ObjectIdentifier(bucketName, key)).withParam((Object)expiration).withParam((Object)contentMd5).withParam((Object)contentType).withParam((Object)method).withParam((Object)sseS3Encryption);
    }

    @MediaType(value="application/octet-stream", strict=false)
    public Result<InputStream, S3ObjectAttributes> getObject(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Summary(value="Specify these parameters in order to define range bytes of an object which is being downloaded.") @ParameterGroup(name="Range", showInDsl=true) @Placement(tab="Advanced") Range range, @Summary(value="The specific version of the object to get its contents, if versioning is enabled. ") @Optional String versionId, @Summary(value="The modified constraint that restricts this request to executing only if the object has been modified after the specified date.") @Optional LocalDateTime modifiedSince, @Summary(value="The unmodified constraint that restricts this request to executing only if the object has not been modified after this date.") @Optional LocalDateTime unmodifiedSince) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ObjectService::getObject).withParam((Object)new VersionedObjectIdentifier(bucketName, key, versionId)).withParam((Object)range).withParam((Object)modifiedSince).withParam((Object)unmodifiedSince);
    }

    public ObjectMetadataParameterGroup getObjectMetadata(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Summary(value="The specific version of the object to get its contents, if versioning is enabled. ") @Optional String versionId) {
        return (ObjectMetadataParameterGroup)this.newExecutionBuilder(config, connection).execute(ObjectService::getObjectMetadata).withParam((Object)new VersionedObjectIdentifier(bucketName, key, versionId));
    }

    public Result<List<Grant>, AccessControlListAttributes> getObjectAcl(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Optional String versionId) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ObjectService::getObjectAcl).withParam((Object)new VersionedObjectIdentifier(bucketName, key, versionId));
    }

    public PagingProvider<S3Connection, S3VersionSummary> listVersions(String bucketName, @Summary(value="Optional parameter restricting the response to keys which begin with the specified prefix. ") @Optional String prefix, @Summary(value="Where in the sorted list of all versions in the specified bucket to begin returning results. Results are always ordered first alphabetically and then from most recent version to least recent version. ") @Optional String keyMarker, @Summary(value="Where in the sorted list of all versions in the specified bucket to begin returning results. Results are always ordered first alphabetically and then from most recent version to least recent version.") @Optional String versionIdMarker, @Summary(value="Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the list. ") @Optional String delimiter, @Summary(value="The maximum number of results to return per page. If not specified, S3 will limit the number of returned results per page.") @Optional Integer maxResults, @Summary(value="The encoding method to be applied on the response. ") @Optional(defaultValue="NOT_ENCODED") EncodingType encodingType) {
        return (PagingProvider)this.newExecutionBuilder(null, null).execute(ObjectService::listVersions).withParam((Object)bucketName).withParam((Object)prefix).withParam((Object)keyMarker).withParam((Object)versionIdMarker).withParam((Object)delimiter).withParam((Object)maxResults).withParam((Object)encodingType);
    }
}

