/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation.bucket;

import java.util.List;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.model.Bucket;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.error.provider.S3ErrorTypeProvider;
import org.mule.extension.s3.internal.operation.S3Operations;
import org.mule.extension.s3.internal.service.bucket.BucketService;
import org.mule.extension.s3.internal.service.bucket.BucketServiceImpl;
import org.mule.extension.s3.internal.util.RegionValueProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={S3ErrorTypeProvider.class})
public class BucketOperations
extends S3Operations<BucketService> {
    public BucketOperations() {
        super(BucketServiceImpl::new);
    }

    public Bucket createBucket(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, @Optional(defaultValue="US_STANDARD") @OfValues(value=RegionValueProvider.class) String region, @DisplayName(value="Canned ACL") @Optional(defaultValue="PRIVATE") CannedAccessControlList acl) {
        return (Bucket)this.newExecutionBuilder(config, connection).execute(BucketService::createBucket).withParam((Object)bucketName).withParam((Object)region).withParam((Object)acl);
    }

    public void deleteBucket(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, @Summary(value="Optional true if the bucket must be deleted even if it is not empty, false if operation should fail in such scenario.") @Optional(defaultValue="false") boolean force) {
        this.newExecutionBuilder(config, connection).execute(BucketService::deleteBucket).withParam((Object)bucketName).withParam((Object)force);
    }

    public List<Bucket> listBuckets(@Config S3Configuration config, @Connection S3Connection connection, @Optional @OfValues(value=RegionValueProvider.class) String region) {
        return (List)this.newExecutionBuilder(config, connection).execute(BucketService::listBuckets).withParam((Object)region);
    }

    @MediaType(value="application/plain")
    public String getBucketLocation(@Config S3Configuration config, @Connection S3Connection connection, String bucketName) {
        return (String)this.newExecutionBuilder(config, connection).execute(BucketService::getBucketLocation).withParam((Object)bucketName);
    }

    @MediaType(value="text/plain")
    public String getBucketPolicy(@Config S3Configuration config, @Connection S3Connection connection, String bucketName) {
        return (String)this.newExecutionBuilder(config, connection).execute(BucketService::getBucketPolicy).withParam((Object)bucketName);
    }

    public void deleteBucketPolicy(@Config S3Configuration config, @Connection S3Connection connection, String bucketName) {
        this.newExecutionBuilder(config, connection).execute(BucketService::deleteBucketPolicy).withParam((Object)bucketName);
    }

    public void setBucketPolicy(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, @Content @Text String policyText) {
        this.newExecutionBuilder(config, connection).execute(BucketService::setBucketPolicy).withParam((Object)bucketName).withParam((Object)policyText);
    }

    public Result<List<Grant>, AccessControlListAttributes> getBucketAcl(@Config S3Configuration config, @Connection S3Connection connection, String bucketName) {
        return (Result)this.newExecutionBuilder(config, connection).execute(BucketService::getBucketAcl).withParam((Object)bucketName);
    }

    public void setBucketAcl(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, Owner owner, @Content List<Grant> grants) {
        this.newExecutionBuilder(config, connection).execute(BucketService::setBucketAcl).withParam((Object)bucketName).withParam((Object)owner).withParam(grants);
    }
}

