/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation.paging;

import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.VersionListing;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.s3.api.model.S3VersionSummary;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.operation.S3ModelFactory;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class VersionListPagingProvider
implements PagingProvider<S3Connection, S3VersionSummary> {
    private final ListVersionsRequest request;
    private VersionListing listing;

    public VersionListPagingProvider(ListVersionsRequest request) {
        this.request = request;
    }

    public List<S3VersionSummary> getPage(S3Connection connection) {
        this.listing = Optional.ofNullable(this.listing).map(connection::listNextBatchOfVersions).orElseGet(() -> connection.listVersions(this.request));
        return this.listing.getVersionSummaries().stream().map(S3ModelFactory::transform).collect(Collectors.toList());
    }

    public Optional<Integer> getTotalResults(S3Connection connection) {
        return Optional.ofNullable(null);
    }

    public void close(S3Connection connection) throws MuleException {
    }
}

