/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.parser;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.internal.parser.ObjectParser;
import org.mule.extension.s3.internal.util.DateUtils;

public class ObjectMetadataParser
implements ObjectParser<ObjectMetadataParameterGroup, ObjectMetadata> {
    @Override
    public ObjectMetadata to(ObjectMetadataParameterGroup input) {
        ObjectMetadata metadata = new ObjectMetadata();
        Optional.ofNullable(input.getLastModified()).map(DateUtils::toDate).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setLastModified(arg_0));
        Optional.ofNullable(input.getSseAlgorithm()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setSSEAlgorithm(arg_0));
        Optional.ofNullable(input.getContentMD5()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentMD5(arg_0));
        Optional.ofNullable(input.getContentLength()).filter(Predicate.isEqual(0L).negate()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentLength(arg_0));
        Optional.ofNullable(input.getContentDisposition()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentDisposition(arg_0));
        Optional.ofNullable(input.getUserMetadata()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setUserMetadata(arg_0));
        Optional.ofNullable(input.getContentType()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentType(arg_0));
        Optional.ofNullable(input.getCacheControl()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setCacheControl(arg_0));
        Optional.ofNullable(input.getContentEncoding()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentEncoding(arg_0));
        Optional.ofNullable(input.getContentLanguage()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setContentLanguage(arg_0));
        Optional.ofNullable(input.getExpirationTime()).map(DateUtils::toDate).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setExpirationTime(arg_0));
        Optional.ofNullable(input.getExpirationTimeRuleId()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setExpirationTimeRuleId(arg_0));
        Optional.ofNullable(input.getHttpExpiresDate()).map(DateUtils::toDate).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setHttpExpiresDate(arg_0));
        Optional.ofNullable(input.isOngoingRestore()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setOngoingRestore(arg_0));
        Optional.ofNullable(input.isRequesterCharged()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setRequesterCharged(arg_0));
        Optional.ofNullable(input.getRestoreExpirationTime()).map(DateUtils::toDate).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setRestoreExpirationTime(arg_0));
        Optional.ofNullable(input.getSseCustomerAlgorithm()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setSSECustomerAlgorithm(arg_0));
        Optional.ofNullable(input.getSseCustomerKeyMd5()).ifPresent(arg_0 -> ((ObjectMetadata)metadata).setSSECustomerKeyMd5(arg_0));
        return metadata;
    }

    @Override
    public ObjectMetadataParameterGroup from(ObjectMetadata input) {
        return new ObjectMetadataParameterGroup(input.getUserMetadata(), DateUtils.toLocalDateTime(input.getLastModified()), input.getContentLength(), input.getContentType(), input.getContentLanguage(), input.getContentEncoding(), input.getCacheControl(), input.getContentMD5(), input.getContentDisposition(), input.getETag(), input.getVersionId(), input.getSSEAlgorithm(), input.getSSECustomerAlgorithm(), input.getSSECustomerKeyMd5(), DateUtils.toLocalDateTime(input.getExpirationTime()), input.getExpirationTimeRuleId(), DateUtils.toLocalDateTime(input.getRestoreExpirationTime()), Optional.ofNullable(input.getOngoingRestore()).orElse(false), DateUtils.toLocalDateTime(input.getHttpExpiresDate()), null, input.getSSEAwsKmsKeyId(), input.isRequesterCharged(), input.getReplicationStatus());
    }
}

