/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.service;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.attributes.S3ObjectAttributes;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.EncodingType;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.HttpMethod;
import org.mule.extension.s3.api.model.KeyVersion;
import org.mule.extension.s3.api.model.ObjectResult;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.api.model.S3VersionSummary;
import org.mule.extension.s3.api.model.SSEAlgorithm;
import org.mule.extension.s3.api.model.StorageClass;
import org.mule.extension.s3.internal.config.group.Range;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.service.ObjectIdentifier;
import org.mule.extension.s3.internal.service.S3Service;
import org.mule.extension.s3.internal.service.VersionedObjectIdentifier;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public interface ObjectService
extends S3Service {
    public ObjectResult createObject(ObjectIdentifier var1, InputStream var2, ObjectMetadataParameterGroup var3, CannedAccessControlList var4, String var5);

    public void deleteObject(VersionedObjectIdentifier var1);

    public void deleteObjects(String var1, List<KeyVersion> var2);

    public PagingProvider<S3Connection, S3ObjectSummary> listObjects(String var1, String var2, String var3, String var4, Integer var5, EncodingType var6);

    public PagingProvider<S3Connection, S3VersionSummary> listVersions(String var1, String var2, String var3, String var4, String var5, Integer var6, EncodingType var7);

    public void setObjectStorageClass(ObjectIdentifier var1, StorageClass var2);

    public Result<List<Grant>, AccessControlListAttributes> getObjectAcl(VersionedObjectIdentifier var1);

    public void setObjectAcl(VersionedObjectIdentifier var1, Owner var2, List<Grant> var3);

    public ObjectResult copyObject(VersionedObjectIdentifier var1, ObjectIdentifier var2, CannedAccessControlList var3, StorageClass var4, Map<String, String> var5, LocalDateTime var6, LocalDateTime var7, String var8, String var9);

    public String createObjectPresignedUri(ObjectIdentifier var1, LocalDateTime var2, String var3, String var4, HttpMethod var5, SSEAlgorithm var6);

    public Result<InputStream, S3ObjectAttributes> getObject(VersionedObjectIdentifier var1, Range var2, LocalDateTime var3, LocalDateTime var4);

    public ObjectMetadataParameterGroup getObjectMetadata(VersionedObjectIdentifier var1);
}

