/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.service;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.attributes.S3ObjectAttributes;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.EncodingType;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.HttpMethod;
import org.mule.extension.s3.api.model.KeyVersion;
import org.mule.extension.s3.api.model.ObjectResult;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.api.model.S3VersionSummary;
import org.mule.extension.s3.api.model.SSEAlgorithm;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.config.group.Range;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.error.S3ErrorType;
import org.mule.extension.s3.internal.operation.S3ModelFactory;
import org.mule.extension.s3.internal.operation.paging.ObjectListPagingProvider;
import org.mule.extension.s3.internal.operation.paging.VersionListPagingProvider;
import org.mule.extension.s3.internal.parser.ObjectMetadataParser;
import org.mule.extension.s3.internal.parser.ObjectParser;
import org.mule.extension.s3.internal.service.ObjectIdentifier;
import org.mule.extension.s3.internal.service.ObjectService;
import org.mule.extension.s3.internal.service.VersionedObjectIdentifier;
import org.mule.extension.s3.internal.util.DateUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class ObjectServiceImpl
extends DefaultConnectorService<S3Configuration, S3Connection>
implements ObjectService {
    private final ObjectParser<ObjectMetadataParameterGroup, ObjectMetadata> objectMetadataParser = new ObjectMetadataParser();

    public ObjectServiceImpl(S3Configuration config, S3Connection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public ObjectResult createObject(ObjectIdentifier objectId, InputStream objectContent, ObjectMetadataParameterGroup objectMetadata, CannedAccessControlList acl, String kmsMasterKey) {
        S3ObjectId s3ObjectId = new S3ObjectId(objectId.getBucketName(), objectId.getKey());
        PutObjectRequest request = new PutObjectRequest(objectId.getBucketName(), objectId.getKey(), objectContent, this.objectMetadataParser.to(objectMetadata));
        request.setBucketName(objectId.getBucketName());
        request.setKey(s3ObjectId.getKey());
        request.setCannedAcl(com.amazonaws.services.s3.model.CannedAccessControlList.valueOf((String)acl.toString()));
        if (kmsMasterKey != null) {
            request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(kmsMasterKey));
        }
        Optional.ofNullable(objectMetadata.getStorageClass()).map(Object::toString).map(StorageClass::fromValue).ifPresent(arg_0 -> ((PutObjectRequest)request).setStorageClass(arg_0));
        PutObjectResult result = ((S3Connection)this.getConnection()).putObject(request);
        return new ObjectResult(result.getETag(), null, result.getVersionId(), DateUtils.toLocalDateTime(result.getExpirationTime()), result.getExpirationTimeRuleId());
    }

    @Override
    public void deleteObject(VersionedObjectIdentifier objectId) {
        if (!StringUtils.isBlank((String)objectId.getVersionId())) {
            ((S3Connection)this.getConnection()).deleteVersion(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId());
        } else {
            ((S3Connection)this.getConnection()).deleteObject(objectId.getBucketName(), objectId.getKey());
        }
    }

    @Override
    public void deleteObjects(String bucketName, List<KeyVersion> keys) {
        if (keys != null && !keys.isEmpty()) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
            ArrayList<DeleteObjectsRequest.KeyVersion> deleteKeysRequest = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            for (KeyVersion key : keys) {
                deleteKeysRequest.add(new DeleteObjectsRequest.KeyVersion(key.getValue(), key.getVersion()));
            }
            deleteObjectsRequest.setKeys(deleteKeysRequest);
            ((S3Connection)this.getConnection()).deleteObjects(deleteObjectsRequest);
        }
    }

    @Override
    public PagingProvider<S3Connection, S3ObjectSummary> listObjects(String bucketName, String prefix, String marker, String delimiter, Integer maxKeys, EncodingType encodingType) {
        return new ObjectListPagingProvider(new ListObjectsRequest(bucketName, prefix, marker, delimiter, maxKeys).withEncodingType(encodingType.getValue()));
    }

    @Override
    public PagingProvider<S3Connection, S3VersionSummary> listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults, EncodingType encodingType) {
        return new VersionListPagingProvider(new ListVersionsRequest(bucketName, prefix, keyMarker, versionIdMarker, delimiter, maxResults).withEncodingType(encodingType.getValue()));
    }

    @Override
    public void setObjectStorageClass(ObjectIdentifier objectId, org.mule.extension.s3.api.model.StorageClass storageClass) {
        ((S3Connection)this.getConnection()).copyObject(new CopyObjectRequest(objectId.getBucketName(), objectId.getKey(), objectId.getBucketName(), objectId.getKey()).withStorageClass(StorageClass.fromValue((String)storageClass.toString()).toString()));
    }

    @Override
    public Result<List<Grant>, AccessControlListAttributes> getObjectAcl(VersionedObjectIdentifier objectId) {
        return S3ModelFactory.wrapAccessControlList(((S3Connection)this.getConnection()).getObjectAcl(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId()));
    }

    @Override
    public void setObjectAcl(VersionedObjectIdentifier objectId, Owner owner, List<Grant> grants) {
        ((S3Connection)this.getConnection()).setObjectAcl(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId(), S3ModelFactory.unwrapAccessControlList(owner, grants));
    }

    @Override
    public ObjectResult copyObject(VersionedObjectIdentifier sourceObjectId, ObjectIdentifier destinationObjectId, CannedAccessControlList destinationAcl, org.mule.extension.s3.api.model.StorageClass destinationStorageClass, Map<String, String> destinationUserMetadata, LocalDateTime modifiedSince, LocalDateTime unmodifiedSince, String encryption, String contentType) {
        CopyObjectRequest request = new CopyObjectRequest(sourceObjectId.getBucketName(), sourceObjectId.getKey(), sourceObjectId.getVersionId(), StringUtils.isBlank((String)destinationObjectId.getBucketName()) ? sourceObjectId.getBucketName() : destinationObjectId.getBucketName(), destinationObjectId.getKey());
        request.setCannedAccessControlList(com.amazonaws.services.s3.model.CannedAccessControlList.valueOf((String)destinationAcl.toString()));
        Optional.ofNullable(destinationStorageClass).map(Object::toString).map(StorageClass::fromValue).ifPresent(arg_0 -> ((CopyObjectRequest)request).setStorageClass(arg_0));
        request.setNewObjectMetadata(new ObjectMetadata());
        Optional.ofNullable(encryption).ifPresent(arg_0 -> ((ObjectMetadata)request.getNewObjectMetadata()).setSSEAlgorithm(arg_0));
        Optional.ofNullable(contentType).ifPresent(arg_0 -> ((ObjectMetadata)request.getNewObjectMetadata()).setContentType(arg_0));
        Optional.ofNullable(destinationUserMetadata).filter(value -> !value.isEmpty()).ifPresent(arg_0 -> ((ObjectMetadata)request.getNewObjectMetadata()).setUserMetadata(arg_0));
        request.setModifiedSinceConstraint(DateUtils.toDate(modifiedSince));
        request.setUnmodifiedSinceConstraint(DateUtils.toDate(unmodifiedSince));
        CopyObjectResult result = ((S3Connection)this.getConnection()).copyObject(request);
        return new ObjectResult(result.getETag(), DateUtils.toLocalDateTime(result.getLastModifiedDate()), result.getVersionId(), DateUtils.toLocalDateTime(result.getExpirationTime()), result.getExpirationTimeRuleId());
    }

    @Override
    public String createObjectPresignedUri(ObjectIdentifier objectId, LocalDateTime expiration, String contentMd5, String contentType, HttpMethod method, SSEAlgorithm sseS3Encryption) {
        try {
            GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(objectId.getBucketName(), objectId.getKey(), com.amazonaws.HttpMethod.valueOf((String)method.name()));
            presignedUrlRequest.setExpiration(DateUtils.toDate(expiration));
            presignedUrlRequest.setContentMd5(contentMd5);
            presignedUrlRequest.setContentType(contentType);
            if (sseS3Encryption != null) {
                presignedUrlRequest.setSSEAlgorithm(sseS3Encryption.toString());
            }
            return ((S3Connection)this.getConnection()).generatePresignedUrl(presignedUrlRequest).toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)S3ErrorType.INVALID_RESPONSE_PRESIGNEDURL_MALFORMED, (Throwable)e);
        }
    }

    @Override
    public Result<InputStream, S3ObjectAttributes> getObject(VersionedObjectIdentifier objectId, Range range, LocalDateTime modifiedSince, LocalDateTime unmodifiedSince) {
        S3Object result = ((S3Connection)this.getConnection()).getObject(new GetObjectRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId()).withModifiedSinceConstraint(DateUtils.toDate(modifiedSince)).withUnmodifiedSinceConstraint(DateUtils.toDate(unmodifiedSince)).withRange(range.getStart().longValue(), range.getEnd().longValue()));
        return Optional.ofNullable(result).map(S3Object::getObjectContent).map(arg_0 -> ((Result.Builder)Result.builder()).output(arg_0)).map(builder -> builder.attributes((Object)new S3ObjectAttributes(result.getKey(), result.getBucketName(), result.getRedirectLocation(), result.isRequesterCharged(), Optional.ofNullable(result.getObjectMetadata()).map(this.objectMetadataParser::from).orElseGet(ObjectMetadataParameterGroup::new)))).orElseGet(Result::builder).mediaType(Optional.ofNullable(result).map(S3Object::getObjectMetadata).map(ObjectMetadata::getContentType).map(MediaType::parse).orElse(MediaType.BINARY)).build();
    }

    @Override
    public ObjectMetadataParameterGroup getObjectMetadata(VersionedObjectIdentifier objectId) {
        ObjectMetadata metadata = ((S3Connection)this.getConnection()).getObjectMetadata(new GetObjectMetadataRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId()));
        return this.objectMetadataParser.from(metadata);
    }
}

