/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.source;

import com.amazonaws.AbortedException;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.FilterRule;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.QueueConfiguration;
import com.amazonaws.services.s3.model.S3Event;
import com.amazonaws.services.s3.model.S3KeyFilter;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.EnumSet;
import org.mule.extension.s3.api.attributes.S3ObjectAttributes;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
public abstract class AbstractObjectSource
extends PollingSource<S3ObjectSummary, S3ObjectAttributes> {
    private static final String DEFAULT_NOTIFICATION_QUEUE_NAME = "MULE-S3-TRIGGER-%s-QUEUE-%s";
    private static final String NOTIFICATION_CONFIGURATION_NAME = "MULE-S3-TRIGGER-%s-%s";
    @Parameter
    private String bucketName;
    private String rawBucketName;
    @Parameter
    @Optional
    private String notificationQueueName;
    @Config
    private S3Configuration config;
    @Connection
    private ConnectionProvider<S3Connection> connectionProvider;
    private S3Connection connection;
    private String notificationQueueUrl;

    abstract String triggerType();

    abstract EnumSet<S3Event> triggerEvents();

    protected void doStart() throws MuleException {
        this.connection = (S3Connection)((Object)this.connectionProvider.connect());
        this.rawBucketName = this.bucketName.split("/")[0];
        this.initializeNotificationQueue();
        this.initializeNotificationConfiguration();
    }

    private void initializeNotificationConfiguration() {
        String notificationConfigurationName;
        BucketNotificationConfiguration bucketNotificationConfiguration = this.connection.getBucketNotificationConfiguration(this.rawBucketName);
        NotificationConfiguration configuration = bucketNotificationConfiguration.getConfigurationByName(notificationConfigurationName = this.getNotificationConfigurationName());
        if (configuration != null) {
            bucketNotificationConfiguration.removeConfiguration(notificationConfigurationName);
        }
        configuration = new QueueConfiguration(this.getNotificationQueueARN(), this.triggerEvents());
        if (this.bucketName.contains("/")) {
            configuration.setFilter(new Filter().withS3KeyFilter(new S3KeyFilter().withFilterRules(new FilterRule[]{new FilterRule().withName("prefix").withValue(this.bucketName.substring(this.bucketName.indexOf("/") + 1) + "/")})));
        }
        bucketNotificationConfiguration.addConfiguration(notificationConfigurationName, configuration);
        this.connection.setBucketNotificationConfiguration(this.rawBucketName, bucketNotificationConfiguration);
    }

    private String getNotificationConfigurationName() {
        return String.format(NOTIFICATION_CONFIGURATION_NAME, this.triggerType(), this.rawBucketName);
    }

    private String getDefaultNotificationQueueName() {
        return String.format(DEFAULT_NOTIFICATION_QUEUE_NAME, this.triggerType(), this.rawBucketName);
    }

    private void initializeNotificationQueue() {
        String queueName = this.getNotificationQueueName();
        try {
            this.notificationQueueUrl = this.connection.getQueueUrl(queueName).getQueueUrl();
        }
        catch (QueueDoesNotExistException e) {
            this.notificationQueueUrl = this.connection.createQueue(queueName).getQueueUrl();
            String policy = "{\n \"Version\": \"2012-10-17\",\n \"Id\": \"example-ID\",\n \"Statement\": [\n  {\n   \"Sid\": \"example-statement-ID\",\n   \"Effect\": \"Allow\",\n   \"Principal\": {\n    \"AWS\":\"*\"  \n   },\n   \"Action\": [\n    \"SQS:SendMessage\"\n   ],\n   \"Resource\": \"" + this.getNotificationQueueARN() + "\",\n   \"Condition\": {\n      \"ArnLike\": { \"aws:SourceArn\": \"arn:aws:s3:*:*:" + this.rawBucketName + "\" }\n   }\n  }\n ]\n}";
            this.connection.setQueueAttributes(this.notificationQueueUrl, Collections.singletonMap("Policy", policy));
        }
    }

    private String getNotificationQueueName() {
        if (!StringUtils.isEmpty((String)this.notificationQueueName)) {
            return this.notificationQueueName;
        }
        return this.getDefaultNotificationQueueName();
    }

    private String getNotificationQueueARN() {
        GetQueueAttributesResult queueAttributes = this.connection.getQueueAttributes(this.notificationQueueUrl, Collections.singletonList("QueueArn"));
        return (String)queueAttributes.getAttributes().get("QueueArn");
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<S3ObjectSummary, S3ObjectAttributes> pollContext) {
        try {
            ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest().withQueueUrl(this.notificationQueueUrl).withMaxNumberOfMessages(Integer.valueOf(10)).withVisibilityTimeout(Integer.valueOf(10)).withWaitTimeSeconds(Integer.valueOf(1));
            ReceiveMessageResult receiveMessageResult = this.connection.receiveMessage(receiveMessageRequest);
            receiveMessageResult.getMessages().forEach(message -> {
                JsonObject jsonNotification = (JsonObject)new GsonBuilder().create().fromJson(message.getBody(), JsonObject.class);
                JsonArray records = jsonNotification.getAsJsonArray("Records");
                if (records != null) {
                    records.forEach(record -> {
                        S3ObjectSummary s3ObjectSummary = this.toS3ObjectSummary(record.getAsJsonObject());
                        pollContext.accept(item -> item.setResult(Result.builder().output((Object)s3ObjectSummary).build()).setId(this.generateUniqueId(message.getMessageId(), s3ObjectSummary.getKey())));
                    });
                }
                this.connection.deleteMessage(this.notificationQueueUrl, message.getReceiptHandle());
            });
        }
        catch (AbortedException abortedException) {
            // empty catch block
        }
    }

    private String generateUniqueId(String sqsMessageId, String s3ObjectId) {
        return sqsMessageId + "-" + s3ObjectId;
    }

    private S3ObjectSummary toS3ObjectSummary(JsonObject record) {
        JsonObject s3Object = record.getAsJsonObject("s3").getAsJsonObject("object");
        String eventTime = this.getString(record, "eventTime");
        String principalId = this.getString(record.getAsJsonObject("userIdentity"), "principalId");
        String key = this.getString(s3Object, "key");
        long size = this.getLong(s3Object, "size");
        String eTag = this.getString(s3Object, "eTag");
        return new S3ObjectSummary(this.bucketName, key, eTag, size, this.toLocalDateTime(eventTime), null, new Owner(principalId, null));
    }

    private String getString(JsonObject jsonObject, String memberName) {
        JsonPrimitive jsonPrimitive = jsonObject.getAsJsonPrimitive(memberName);
        return jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
    }

    private long getLong(JsonObject jsonObject, String memberName) {
        JsonPrimitive jsonPrimitive = jsonObject.getAsJsonPrimitive(memberName);
        return jsonPrimitive != null ? jsonPrimitive.getAsLong() : 0L;
    }

    private LocalDateTime toLocalDateTime(String eventTime) {
        return LocalDateTime.ofInstant(Instant.parse(eventTime), ZoneId.systemDefault());
    }

    public void onRejectedItem(Result<S3ObjectSummary, S3ObjectAttributes> result, SourceCallbackContext sourceCallbackContext) {
    }
}

