/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.config;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.extension.sqs.internal.connection.provider.AssumeRoleConnectionProvider;
import org.mule.extension.sqs.internal.connection.provider.BasicConnectionProvider;
import org.mule.extension.sqs.internal.error.exception.MissingQueueUrlException;
import org.mule.extension.sqs.internal.operation.SQSOperations;
import org.mule.extension.sqs.internal.source.ReceiveMessagesSource;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

@Configuration(name="config")
@DisplayName(value="Configuration")
@Operations(value={SQSOperations.class})
@ConnectionProviders(value={BasicConnectionProvider.class, AssumeRoleConnectionProvider.class})
@Sources(value={ReceiveMessagesSource.class})
public class SQSConfiguration
implements ConnectorConfig {
    public static final int MAX_WAIT_TIME = 20;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="Default Global Queue URL")
    @Summary(value="This value is used when you do not set queue url on the operation level. If you do not specify the queue url here or on the operation level the exception is thrown. A queue URL is constructed in the following format: https://sqs.{REGION}.amazonaws.com/{ACCOUNT_NUMBER}/{QUEUE_NAME} Example: https://sqs.us-east-1.amazonaws.com/123456789101/test-queue")
    @ExcludeFromConnectivitySchema
    private String defaultQueueUrl;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="20")
    @Placement(tab="Advanced", order=1)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Default Wait Time")
    @Summary(value="Default value for the maximum duration of a single poll, in seconds. Valid values are from 0 to 20. Use 0 for short polling.")
    @ExcludeFromConnectivitySchema
    private int waitTime;

    public String getDefaultQueueUrl() {
        return this.defaultQueueUrl;
    }

    public void setDefaultQueueUrl(String defaultQueueUrl) {
        this.defaultQueueUrl = defaultQueueUrl;
    }

    public String getUrl(String queueUrl) {
        return Optional.ofNullable(Optional.ofNullable(queueUrl).filter(Predicate.isEqual("").negate()).orElse(this.defaultQueueUrl)).orElseThrow(MissingQueueUrlException::new);
    }

    public int getWaitTime() {
        return this.waitTime;
    }
}

