/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import java.util.List;
import java.util.function.Function;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.sqs.internal.error.SQSExceptionHandler;
import org.mule.extension.sqs.internal.error.exception.MissingTestQueueArnException;
import org.mule.extension.sqs.internal.error.exception.S3BucketAccessDeniedException;
import org.mule.extension.sqs.internal.error.exception.S3BucketNotFoundException;
import org.mule.extension.sqs.internal.error.exception.SQSRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQSConnection
implements ConnectorConnection {
    private static final Logger logger = LoggerFactory.getLogger(SQSConnection.class);
    private final String testQueueName;
    private final AmazonSQS amazonSQS;

    public SQSConnection(AmazonSQS client, String testQueueName) {
        this.amazonSQS = client;
        this.testQueueName = testQueueName;
    }

    public void disconnect() {
        this.amazonSQS.shutdown();
    }

    public void validate() {
        if (this.testQueueName == null) {
            throw new MissingTestQueueArnException();
        }
        try {
            this.amazonSQS.getQueueUrl(this.testQueueName);
        }
        catch (SdkClientException e) {
            throw SQSExceptionHandler.wrapException((Exception)((Object)e));
        }
    }

    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) {
        return this.amazonSQS.addPermission(addPermissionRequest);
    }

    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).changeMessageVisibility(arg_0), changeMessageVisibilityRequest);
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).changeMessageVisibilityBatch(arg_0), changeMessageVisibilityBatchRequest);
    }

    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) {
        return this.amazonSQS.createQueue(createQueueRequest);
    }

    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).deleteMessage(arg_0), deleteMessageRequest);
    }

    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).deleteMessageBatch(arg_0), deleteMessageBatchRequest);
    }

    public DeleteQueueResult deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        return this.amazonSQS.deleteQueue(deleteQueueRequest);
    }

    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        return this.amazonSQS.getQueueUrl(getQueueUrlRequest);
    }

    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        return this.amazonSQS.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    public ListQueuesResult listQueues(ListQueuesRequest listQueuesRequest) {
        return this.amazonSQS.listQueues(listQueuesRequest);
    }

    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        return this.amazonSQS.purgeQueue(purgeQueueRequest);
    }

    public RemovePermissionResult removePermission(RemovePermissionRequest removePermissionRequest) {
        return this.amazonSQS.removePermission(removePermissionRequest);
    }

    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).sendMessage(arg_0), sendMessageRequest);
    }

    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.invoke(client -> client.sendMessageBatch(queueUrl, entries), this.amazonSQS);
    }

    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        return this.amazonSQS.setQueueAttributes(setQueueAttributesRequest);
    }

    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        return this.amazonSQS.getQueueAttributes(getQueueAttributesRequest);
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        return this.invoke(arg_0 -> ((AmazonSQS)this.amazonSQS).receiveMessage(arg_0), receiveMessageRequest);
    }

    private <T, R> R invoke(Function<T, R> function, T param) {
        try {
            return function.apply(param);
        }
        catch (AmazonServiceException e) {
            if (e.getCause() instanceof AmazonS3Exception) {
                AmazonS3Exception amazonS3Exception = (AmazonS3Exception)e.getCause();
                switch (amazonS3Exception.getStatusCode()) {
                    case 403: {
                        throw new S3BucketAccessDeniedException(amazonS3Exception.getErrorMessage());
                    }
                    case 404: {
                        throw new S3BucketNotFoundException(amazonS3Exception.getErrorMessage());
                    }
                }
                throw new SQSRuntimeException((Throwable)amazonS3Exception);
            }
            throw e;
        }
    }
}

