/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClient;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.sqs.api.LargePayloadSupport;
import org.mule.extension.sqs.internal.connection.SQSConnection;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.extension.sqs.internal.connection.provider.group.ProxyParameterGroup;
import org.mule.extension.sqs.internal.error.exception.MessageThresholdOutOfRangeException;
import org.mule.extension.sqs.internal.error.exception.SQSRuntimeException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class AbstractConnectionProvider
extends ConnectorConnectionProvider<SQSConnection>
implements CachedConnectionProvider<SQSConnection>,
Initialisable {
    @Parameter
    @DisplayName(value="Test Queue ARN")
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=3)
    @Summary(value="This parameter is used to test connection to SQS connector. If you do not specify this parameter the test connection is not performed. A queue ARN is constructed in the following format: arn:aws:{REGION}:{ACCOUNT_NUMBER}:{QUEUE_NAME}. Example: arn:aws:sqs:us-east-1:123456789101:test-queue")
    private String testQueueArn;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="Large Payload Support")
    @Placement(order=1, tab="Advanced")
    private LargePayloadSupport largePayloadSupport;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private CommonParameters commonParameters;
    @ParameterGroup(name="Proxy")
    @Placement(order=1)
    private ProxyParameterGroup proxyParameterGroup;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.commonParameters.getTlsContext());
    }

    public SQSConnection connect() throws ConnectionException {
        try {
            ClientConfiguration clientConfiguration = this.getClientConfiguration();
            AmazonSQSClientBuilder sqsClientBuilder = (AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(clientConfiguration);
            String formattedRegion = this.commonParameters.getRegion().toLowerCase().replace('_', '-');
            if (this.commonParameters.getCustomSqsEndpoint() != null) {
                sqsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.commonParameters.getCustomSqsEndpoint(), formattedRegion));
            } else {
                sqsClientBuilder.withRegion(formattedRegion);
            }
            if (this.commonParameters.isTryDefaultAWSCredentialsProviderChain() || Optional.ofNullable(this.commonParameters.getAccessKey()).filter(Predicate.isEqual("").negate()).isPresent() && Optional.ofNullable(this.commonParameters.getSecretKey()).filter(Predicate.isEqual("").negate()).isPresent()) {
                sqsClientBuilder.withCredentials(this.getAWSCredentialsProvider(this.commonParameters));
                AwsSdkMetrics.unregisterMetricAdminMBean();
                ExtendedClientConfiguration extendedClientConfiguration = new ExtendedClientConfiguration();
                if (this.largePayloadSupport != null) {
                    AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(this.getAWSCredentialsProvider(this.commonParameters));
                    if (this.largePayloadSupport.getCustomS3Endpoint() != null) {
                        s3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.largePayloadSupport.getCustomS3Endpoint(), formattedRegion));
                    } else {
                        s3ClientBuilder.withRegion(formattedRegion);
                    }
                    extendedClientConfiguration.withPayloadSupportEnabled((AmazonS3)s3ClientBuilder.build(), this.largePayloadSupport.getBucket()).withPayloadSizeThreshold(this.getMessageSizeThresholdInBytes(this.largePayloadSupport.getMessageSizeThresholdUnit(), this.largePayloadSupport.getMessageSizeThreshold()));
                }
                return new SQSConnection((AmazonSQS)new AmazonSQSExtendedClient((AmazonSQS)sqsClientBuilder.build(), extendedClientConfiguration), this.parseTestQueueName(this.testQueueArn));
            }
            throw new SQSRuntimeException("Access Key or Secret Key is blank");
        }
        catch (KeyManagementException | NoSuchAlgorithmException | SQSRuntimeException e) {
            throw new ConnectionException(((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    protected abstract AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters var1) throws ConnectionException;

    protected ClientConfiguration getClientConfiguration() throws NoSuchAlgorithmException, KeyManagementException {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withProxyUsername(this.proxyParameterGroup.getProxyUsername()).withProxyPassword(this.proxyParameterGroup.getProxyPassword()).withProxyHost(this.proxyParameterGroup.getProxyHost()).withProxyDomain(this.proxyParameterGroup.getProxyDomain()).withProxyWorkstation(this.proxyParameterGroup.getProxyWorkstation()).withProxyPort(this.proxyParameterGroup.getProxyPort()).withSocketTimeout(this.commonParameters.getSocketTimeoutInMillis()).withConnectionTimeout(this.commonParameters.getConnectionTimeoutInMillis());
        if (this.commonParameters.getTlsContext() != null) {
            clientConfiguration.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(this.commonParameters.getTlsContext().createSslContext()));
        }
        if (this.commonParameters.getMaxConnections() > 0) {
            clientConfiguration.setMaxConnections(this.commonParameters.getMaxConnections());
        }
        return clientConfiguration;
    }

    private int getMessageSizeThresholdInBytes(DataUnit messageSizeThresholdUnit, int messageSizeThreshold) {
        if (messageSizeThreshold <= 0) {
            throw new MessageThresholdOutOfRangeException();
        }
        switch (messageSizeThresholdUnit) {
            case BYTE: {
                if (messageSizeThreshold <= 262144) {
                    return messageSizeThreshold;
                }
                throw new MessageThresholdOutOfRangeException();
            }
            case KB: {
                if (messageSizeThreshold <= 256) {
                    return messageSizeThreshold * 1024;
                }
                throw new MessageThresholdOutOfRangeException();
            }
        }
        throw new MessageThresholdOutOfRangeException();
    }

    public String parseTestQueueName(String testQueueArn) {
        int lastColon;
        if (testQueueArn != null && (lastColon = testQueueArn.lastIndexOf(58)) != -1) {
            return testQueueArn.substring(lastColon + 1);
        }
        return null;
    }
}

