/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.mule.extension.sqs.internal.connection.provider.AbstractConnectionProvider;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

@Alias(value="role")
public class AssumeRoleConnectionProvider
extends AbstractConnectionProvider {
    @Parameter
    @DisplayName(value="Role ARN")
    @Summary(value="The Role ARN unique identifies role to assume in order to gain cross account access.")
    @Placement(order=1)
    private String roleARN;
    @Parameter
    @DisplayName(value="Custom STS Endpoint")
    @Optional
    @Placement(tab="Advanced", order=1)
    @Summary(value="Sets a custom STS endpoint. Useful when a non-standard service endpoint is required, such as a VPC endpoint.")
    @ExcludeFromConnectivitySchema
    private String customStsEndpoint;

    @Override
    protected AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) throws ConnectionException {
        try {
            DefaultAWSCredentialsProviderChain credentialsProvider = commonParameters.isTryDefaultAWSCredentialsProviderChain() ? DefaultAWSCredentialsProviderChain.getInstance() : new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey()));
            AWSSecurityTokenServiceClientBuilder awsSecurityTokenServiceClientBuilder = (AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withClientConfiguration(this.getClientConfiguration())).withCredentials((AWSCredentialsProvider)credentialsProvider);
            String formattedRegion = commonParameters.getRegion().toLowerCase().replace('_', '-');
            if (this.customStsEndpoint != null) {
                awsSecurityTokenServiceClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.customStsEndpoint, formattedRegion));
            } else {
                awsSecurityTokenServiceClientBuilder.withRegion(formattedRegion);
            }
            return new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleARN, "WithRoleARN").withStsClient((AWSSecurityTokenService)awsSecurityTokenServiceClientBuilder.build()).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

