/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.mule.extension.sqs.internal.connection.provider.AbstractConnectionProvider;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.SecurityToken;

@Alias(value="basic")
public class BasicConnectionProvider
extends AbstractConnectionProvider {
    @Parameter
    @DisplayName(value="Session Token")
    @Placement(order=1)
    @Optional
    @Summary(value="The session token provided by Amazon STS.")
    @SecurityToken
    private String sessionToken;

    @Override
    protected AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) {
        if (commonParameters.isTryDefaultAWSCredentialsProviderChain()) {
            return new DefaultAWSCredentialsProviderChain();
        }
        if (StringUtils.isBlank((String)this.sessionToken)) {
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey()));
        }
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey(), this.sessionToken));
    }
}

