/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.error;

import com.amazonaws.AmazonServiceException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.extension.sqs.internal.error.SQSErrorType;
import org.mule.extension.sqs.internal.error.exception.SQSRuntimeException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class SQSExceptionHandler
extends ExceptionHandler {
    private static final Set<SQSErrorType> SQS_ERROR_TYPES = Stream.of(SQSErrorType.values()).collect(Collectors.toSet());

    public Exception enrichException(Exception e) {
        if (e instanceof MuleException || e instanceof MuleRuntimeException) {
            return e;
        }
        return SQSExceptionHandler.wrapException(e);
    }

    public static MuleRuntimeException wrapException(Exception e) {
        return Optional.of(e).filter(AmazonServiceException.class::isInstance).map(AmazonServiceException.class::cast).map(AmazonServiceException::getErrorCode).map(code -> code.replace('.', '_')).map(SQSExceptionHandler::camelToSnake).map(sqsErrorCode -> SQS_ERROR_TYPES.stream().filter(errorType -> sqsErrorCode.equals(errorType.name()) || errorType.getErrorCodes().contains(sqsErrorCode)).findAny()).filter(Optional::isPresent).map(Optional::get).map(errorType -> new ModuleException((ErrorTypeDefinition)errorType, (Throwable)e)).orElseGet(() -> new SQSRuntimeException(e));
    }

    private static String camelToSnake(String camelCaseString) {
        return camelCaseString.replaceAll("([a-z])([A-Z]+)", "$1_$2").toUpperCase();
    }
}

