/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.operation;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.sqs.api.model.BatchResult;
import org.mule.extension.sqs.api.model.BatchResultErrorEntry;
import org.mule.extension.sqs.api.model.ChangeMessageVisibilityBatchRequestEntry;
import org.mule.extension.sqs.api.model.DeleteMessageBatchRequestEntry;
import org.mule.extension.sqs.api.model.MessageAttributeValue;
import org.mule.extension.sqs.api.model.SendMessageResult;
import org.mule.runtime.core.api.util.IOUtils;

public class SQSModelFactory {
    private SQSModelFactory() {
    }

    public static BatchResultErrorEntry transform(com.amazonaws.services.sqs.model.BatchResultErrorEntry awsBatchResultErrorEntry) {
        return new BatchResultErrorEntry(awsBatchResultErrorEntry.getId(), awsBatchResultErrorEntry.getSenderFault(), awsBatchResultErrorEntry.getCode(), awsBatchResultErrorEntry.getMessage());
    }

    public static List<com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry> getChangeMessageVisibilityBatchRequestEntries(List<ChangeMessageVisibilityBatchRequestEntry> requestEntries) {
        ArrayList<com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry> awsRequestEntries = new ArrayList<com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry>();
        if (requestEntries != null && !requestEntries.isEmpty()) {
            for (ChangeMessageVisibilityBatchRequestEntry requestEntry : requestEntries) {
                com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry awsRequestEntry = new com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry();
                awsRequestEntry.setId(requestEntry.getId());
                awsRequestEntry.setReceiptHandle(requestEntry.getReceiptHandle());
                awsRequestEntry.setVisibilityTimeout(requestEntry.getVisibilityTimeout());
                awsRequestEntries.add(awsRequestEntry);
            }
        }
        return awsRequestEntries;
    }

    public static List<com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry> getDeleteMessageBatchRequestEntries(List<DeleteMessageBatchRequestEntry> requestEntries) {
        ArrayList<com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry> awsRequestEntries = new ArrayList<com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry>();
        if (requestEntries != null && !requestEntries.isEmpty()) {
            for (DeleteMessageBatchRequestEntry requestEntry : requestEntries) {
                com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry awsRequestEntry = new com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry();
                awsRequestEntry.setId(requestEntry.getId());
                awsRequestEntry.setReceiptHandle(requestEntry.getReceiptHandle());
                awsRequestEntries.add(awsRequestEntry);
            }
        }
        return awsRequestEntries;
    }

    public static Map<String, com.amazonaws.services.sqs.model.MessageAttributeValue> getMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        HashMap<String, com.amazonaws.services.sqs.model.MessageAttributeValue> awsMessageAttributes = new HashMap<String, com.amazonaws.services.sqs.model.MessageAttributeValue>();
        if (messageAttributes != null && !messageAttributes.isEmpty()) {
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                MessageAttributeValue attributeValue = entry.getValue();
                com.amazonaws.services.sqs.model.MessageAttributeValue awsMsgAttributeValue = new com.amazonaws.services.sqs.model.MessageAttributeValue();
                awsMsgAttributeValue.setDataType(attributeValue.getDataType());
                awsMsgAttributeValue.setStringValue(attributeValue.getStringValue());
                awsMsgAttributeValue.setBinaryValue((ByteBuffer)Optional.ofNullable(attributeValue.getBinaryValue()).map(IOUtils::toByteArray).map(ByteBuffer::wrap).orElse(null));
                awsMessageAttributes.put(entry.getKey(), awsMsgAttributeValue);
            }
        }
        return awsMessageAttributes;
    }

    public static SendMessageResult getSendMessageResult(String messageId, String md5OfMessageBody, String md5OfMessageAttributes) {
        return new SendMessageResult(md5OfMessageBody, md5OfMessageAttributes, messageId);
    }

    public static List<SendMessageBatchRequestEntry> getSendMessageBatchRequestEntries(List<org.mule.extension.sqs.api.model.Message> messages) {
        return Optional.ofNullable(messages).orElseGet(ArrayList::new).stream().map(message -> new SendMessageBatchRequestEntry().withDelaySeconds(message.getDelaySeconds()).withId(message.getId()).withMessageAttributes(SQSModelFactory.getMessageAttributes(message.getMessageAttributes())).withMessageBody(message.getBody()).withMessageGroupId(message.getGroupId())).collect(Collectors.toList());
    }

    public static BatchResult getSendMessageBatchResult(SendMessageBatchResult batchResult) {
        List<String> successEntryIds = Collections.emptyList();
        if (batchResult.getSuccessful() != null && !batchResult.getSuccessful().isEmpty()) {
            successEntryIds = new ArrayList();
            for (SendMessageBatchResultEntry awsBatchResultEntry : batchResult.getSuccessful()) {
                successEntryIds.add(awsBatchResultEntry.getId());
            }
        }
        List<BatchResultErrorEntry> batchResultErrorEntries = Collections.emptyList();
        return new BatchResult(successEntryIds, SQSModelFactory.getBatchResultErrorEntries(batchResult.getFailed(), batchResultErrorEntries));
    }

    private static List<BatchResultErrorEntry> getBatchResultErrorEntries(List<com.amazonaws.services.sqs.model.BatchResultErrorEntry> awsBatchResultErrorEntries, List<BatchResultErrorEntry> batchResultErrorEntries) {
        if (awsBatchResultErrorEntries != null && !awsBatchResultErrorEntries.isEmpty()) {
            batchResultErrorEntries = new ArrayList<BatchResultErrorEntry>(awsBatchResultErrorEntries.size());
            for (com.amazonaws.services.sqs.model.BatchResultErrorEntry batchResultErrorEntry : awsBatchResultErrorEntries) {
                batchResultErrorEntries.add(SQSModelFactory.transform(batchResultErrorEntry));
            }
        }
        return batchResultErrorEntries;
    }

    public static Map<String, Object> wrapMessageAttributes(Message awsMessage) {
        HashMap<String, Object> properties = new HashMap<String, Object>(awsMessage.getAttributes());
        properties.put("sqs.message.id", awsMessage.getMessageId());
        properties.put("sqs.message.receipt.handle", awsMessage.getReceiptHandle());
        properties.putAll(SQSModelFactory.getSqsMessageAttributes(awsMessage));
        return properties;
    }

    public static org.mule.extension.sqs.api.model.Message wrapMessage(Message message) {
        return new org.mule.extension.sqs.api.model.Message(message.getMessageId(), message.getReceiptHandle(), message.getBody(), null, null, null, SQSModelFactory.getSqsMessageAttributes(message));
    }

    private static Map<String, MessageAttributeValue> getSqsMessageAttributes(Message message) {
        Map awsMessageAttributes = message.getMessageAttributes();
        HashMap<String, MessageAttributeValue> finalAttributes = new HashMap<String, MessageAttributeValue>(awsMessageAttributes.size());
        if (awsMessageAttributes.size() > 0) {
            awsMessageAttributes.forEach((key, value) -> {
                MessageAttributeValue attributeValue = new MessageAttributeValue(value.getStringValue(), (InputStream)new ByteBufferBackedInputStream(value.getBinaryValue()), value.getDataType());
                finalAttributes.put((String)key, attributeValue);
            });
        }
        return finalAttributes;
    }
}

