/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.operation;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.mule.extension.sqs.api.attributes.RequestIDAttribute;
import org.mule.extension.sqs.api.model.BatchResult;
import org.mule.extension.sqs.api.model.ChangeMessageVisibilityBatchRequestEntry;
import org.mule.extension.sqs.api.model.DeleteMessageBatchRequestEntry;
import org.mule.extension.sqs.api.model.Message;
import org.mule.extension.sqs.api.model.SendMessageResult;
import org.mule.extension.sqs.internal.config.SQSConfiguration;
import org.mule.extension.sqs.internal.connection.SQSConnection;
import org.mule.extension.sqs.internal.error.exception.WaitTimeOutOfRangeException;
import org.mule.extension.sqs.internal.error.provider.AddPermissionErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.ChangeMessageVisibilityErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.CommonErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.CreateQueueErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.LargePayloadErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.PurgeQueueErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.ReadErrorTypeProvider;
import org.mule.extension.sqs.internal.operation.SQSModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class SQSOperations {
    @MediaType(value="text/plain")
    @Throws(value={AddPermissionErrorTypeProvider.class})
    public String addPermission(@Config SQSConfiguration config, @Connection SQSConnection client, String label, List<String> accountIds, List<String> actions, @Summary(value="Permissions will be added to the queue represented by this URL. This parameter is optional, and if you do not specify queueUrl, you must specify the default global queue URL at the configuration level.") @Optional String queueUrl) {
        return client.addPermission(new AddPermissionRequest(config.getUrl(queueUrl), label, accountIds, actions)).getSdkResponseMetadata().getRequestId();
    }

    @MediaType(value="text/plain")
    @Throws(value={ChangeMessageVisibilityErrorTypeProvider.class})
    public String changeMessageVisibility(@Config SQSConfiguration config, @Connection SQSConnection client, @Optional @Example(value="#[header:inbound:sqs.message.receipt.handle]") String receiptHandle, Integer visibilityTimeout, @Optional(defaultValue="SECONDS") TimeUnit visibilityTimeoutUnit, @Summary(value="The URL of the Amazon SQS queue to take action on. This parameter is optional, and if you do not specify queueUrl, you must specify the Default Global Queue URL at the configuration level.") @Optional String queueUrl) {
        return client.changeMessageVisibility(new ChangeMessageVisibilityRequest(config.getUrl(queueUrl), receiptHandle, Integer.valueOf(Math.toIntExact(visibilityTimeoutUnit.toSeconds(visibilityTimeout.intValue()))))).getSdkResponseMetadata().getRequestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> changeMessageVisibilityBatch(@Config SQSConfiguration config, @Connection SQSConnection client, @Content List<ChangeMessageVisibilityBatchRequestEntry> receiptHandles, @Summary(value="The URL of the Amazon SQS queue to take action on. This parameter is optional, and if you do not specify queueUrl, you must specify the Default Global Queue URL at the configuration level.") @Optional String queueUrl) {
        ChangeMessageVisibilityBatchResult batchResult = client.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest(config.getUrl(queueUrl), SQSModelFactory.getChangeMessageVisibilityBatchRequestEntries(receiptHandles)));
        BatchResult result = new BatchResult(batchResult.getSuccessful().stream().map(ChangeMessageVisibilityBatchResultEntry::getId).collect(Collectors.toList()), batchResult.getFailed().stream().map(SQSModelFactory::transform).collect(Collectors.toList()));
        return this.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)batchResult);
    }

    @MediaType(value="text/plain")
    @Throws(value={CreateQueueErrorTypeProvider.class})
    public Result<String, RequestIDAttribute> createQueue(@Connection SQSConnection client, String queueName, @NullSafe @Optional @Content Map<String, String> attributes) {
        CreateQueueResult result = client.createQueue(new CreateQueueRequest(queueName).withAttributes(attributes));
        return this.getResult(result.getQueueUrl(), (AmazonWebServiceResult<ResponseMetadata>)result, org.mule.runtime.api.metadata.MediaType.TEXT);
    }

    @MediaType(value="text/plain")
    @Throws(value={LargePayloadErrorTypeProvider.class})
    public String deleteMessage(@Config SQSConfiguration config, @Connection SQSConnection client, String receiptHandle, @Summary(value="URL of the queue to delete messages from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.deleteMessage(new DeleteMessageRequest(config.getUrl(queueUrl), receiptHandle)).getSdkResponseMetadata().getRequestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> deleteMessageBatch(@Config SQSConfiguration config, @Connection SQSConnection client, List<DeleteMessageBatchRequestEntry> entries, @Summary(value="URL of the queue to delete messages as a batch from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        DeleteMessageBatchResult batchResult = client.deleteMessageBatch(new DeleteMessageBatchRequest(config.getUrl(queueUrl), SQSModelFactory.getDeleteMessageBatchRequestEntries(entries)));
        BatchResult result = new BatchResult(batchResult.getSuccessful().stream().map(DeleteMessageBatchResultEntry::getId).collect(Collectors.toList()), batchResult.getFailed().stream().map(SQSModelFactory::transform).collect(Collectors.toList()));
        return this.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)batchResult);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String deleteQueue(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="URL of the queue to delete. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.deleteQueue(new DeleteQueueRequest(config.getUrl(queueUrl))).getSdkResponseMetadata().getRequestId();
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<Map<String, String>, RequestIDAttribute> getQueueAttributes(@Config SQSConfiguration config, @Connection SQSConnection client, @Optional @NullSafe List<String> attributeNames, @Summary(value="URL of the Amazon SQS queue to take action on This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        GetQueueAttributesResult queueAttributes = client.getQueueAttributes(new GetQueueAttributesRequest(config.getUrl(queueUrl)).withAttributeNames(attributeNames));
        return this.getResult(queueAttributes.getAttributes(), (AmazonWebServiceResult<ResponseMetadata>)queueAttributes);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public Result<String, RequestIDAttribute> getQueueUrl(@Connection SQSConnection client, String queueName, @Optional String queueOwnerAWSAccountId) {
        GetQueueUrlResult result = client.getQueueUrl(new GetQueueUrlRequest(queueName).withQueueOwnerAWSAccountId(queueOwnerAWSAccountId));
        return this.getResult(result.getQueueUrl(), (AmazonWebServiceResult<ResponseMetadata>)result, org.mule.runtime.api.metadata.MediaType.TEXT);
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<List<String>, RequestIDAttribute> listDeadLetterSourceQueues(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL of a dead-letter queue. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        ListDeadLetterSourceQueuesResult result = client.listDeadLetterSourceQueues(new ListDeadLetterSourceQueuesRequest().withQueueUrl(config.getUrl(queueUrl)));
        return this.getResult(result.getQueueUrls(), (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<List<String>, RequestIDAttribute> listQueues(@Connection SQSConnection client, @Optional String queueNamePrefix) {
        ListQueuesResult result = client.listQueues(new ListQueuesRequest(queueNamePrefix));
        return this.getResult(result.getQueueUrls(), (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    @MediaType(value="text/plain")
    @Throws(value={PurgeQueueErrorTypeProvider.class})
    public String purgeQueue(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL where messages are to be fetched from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.purgeQueue(new PurgeQueueRequest(config.getUrl(queueUrl))).getSdkResponseMetadata().getRequestId();
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String removePermission(@Config SQSConfiguration config, @Connection SQSConnection client, String label, @Summary(value="Permissions will be deleted from the queue represented by this URL This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.removePermission(new RemovePermissionRequest(config.getUrl(queueUrl), label)).getSdkResponseMetadata().getRequestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<SendMessageResult, RequestIDAttribute> sendMessage(@Config SQSConfiguration config, @Connection SQSConnection client, @Content Message message, @Summary(value="Queue where the message is to be sent. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        com.amazonaws.services.sqs.model.SendMessageResult result = client.sendMessage(new SendMessageRequest(config.getUrl(queueUrl), message.getBody()).withDelaySeconds(message.getDelaySeconds()).withMessageAttributes(SQSModelFactory.getMessageAttributes(message.getMessageAttributes())).withMessageDeduplicationId(message.getDeduplicationId()).withMessageGroupId(message.getGroupId()));
        SendMessageResult payload = new SendMessageResult(result.getMD5OfMessageBody(), result.getMD5OfMessageAttributes(), result.getMessageId());
        return this.getResult(payload, (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> sendMessageBatch(@Config SQSConfiguration config, @Connection SQSConnection client, @Content List<Message> messages, @Summary(value="Queue where the message is to be sent. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        SendMessageBatchResult result = client.sendMessageBatch(config.getUrl(queueUrl), SQSModelFactory.getSendMessageBatchRequestEntries(messages));
        return this.getResult(SQSModelFactory.getSendMessageBatchResult(result), (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String setQueueAttributes(@Config SQSConfiguration config, @Connection SQSConnection client, @Content Map<String, String> attributes, @Summary(value="URL of the queue This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.setQueueAttributes(new SetQueueAttributesRequest(config.getUrl(queueUrl), attributes)).getSdkResponseMetadata().getRequestId();
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<Integer, RequestIDAttribute> getApproximateNumberOfMessages(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="URL of the queue. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        GetQueueAttributesResult result = client.getQueueAttributes(new GetQueueAttributesRequest(config.getUrl(queueUrl)).withAttributeNames(new String[]{"ApproximateNumberOfMessages"}));
        return this.getResult(Integer.parseInt((String)result.getAttributes().get("ApproximateNumberOfMessages")), (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    @Throws(value={ReadErrorTypeProvider.class})
    public Result<List<Message>, RequestIDAttribute> read(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl, @Summary(value="Maximum duration of a single poll, in seconds. Valid values are from 0 to 20. Use 0 for short polling.") @Placement(tab="Advanced") @DisplayName(value="Wait time") @ConfigOverride int waitTime, int maxNumberOfMessages) {
        if (waitTime < 0 || waitTime > 20) {
            throw new WaitTimeOutOfRangeException(waitTime);
        }
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(config.getUrl(queueUrl)).withAttributeNames(new String[]{"All"}).withMessageAttributeNames(new String[]{"All"}).withMaxNumberOfMessages(Integer.valueOf(maxNumberOfMessages)).withWaitTimeSeconds(Integer.valueOf(waitTime));
        ReceiveMessageResult result = client.receiveMessage(receiveMessageRequest);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (com.amazonaws.services.sqs.model.Message message : result.getMessages()) {
            Message wrappedMessage = SQSModelFactory.wrapMessage(message);
            messages.add(wrappedMessage);
        }
        return this.getResult(messages, (AmazonWebServiceResult<ResponseMetadata>)result);
    }

    private <T> Result<T, RequestIDAttribute> getResult(T payload, AmazonWebServiceResult<ResponseMetadata> amazonWebServiceResult) {
        return this.getResult(payload, amazonWebServiceResult, null);
    }

    private <T> Result<T, RequestIDAttribute> getResult(T payload, AmazonWebServiceResult<ResponseMetadata> amazonWebServiceResult, org.mule.runtime.api.metadata.MediaType mediaType) {
        return Result.builder().mediaType(mediaType).output(payload).attributes((Object)new RequestIDAttribute(amazonWebServiceResult.getSdkResponseMetadata().getRequestId())).build();
    }
}

