/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.api;

import java.util.Objects;
import org.mule.extension.sqs.api.utility.DataUnit;
import org.mule.extension.sqs.api.utility.ExcludeFromGeneratedCoverage;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class LargePayloadSupport {
    @Parameter
    @Example(value="large-payload-bucket")
    @DisplayName(value="Bucket")
    @Placement(order=1)
    @Summary(value="Name of the AWS S3 bucket in which to store large payload messages. The AWS S3 bucket must already be created and configured in AWS S3. Enabling this feature incurs additional charges for using AWS S3.")
    private String bucket;
    @Parameter
    @DisplayName(value="Message Size Threshold")
    @Optional(defaultValue="256")
    @Placement(order=2)
    @Summary(value="The message size threshold value for storing message payloads in the AWS S3 bucket. The default value for the message size threshold is 256 KB and the maximum threshold size value is 256 KB. The maximum message size is 2 GB.")
    private int messageSizeThreshold;
    @Parameter
    @DisplayName(value="Message Size Threshold Unit")
    @Optional(defaultValue="KB")
    @Placement(order=3)
    @Summary(value="Sets the data unit for the message size threshold.")
    private DataUnit messageSizeThresholdUnit;
    @Parameter
    @DisplayName(value="Custom S3 Endpoint")
    @Optional
    @Placement(order=4)
    @Summary(value="Sets a custom S3 endpoint. Useful when a non-standard service endpoint is required, such as a VPC endpoint.")
    private String customS3Endpoint;

    public String getBucket() {
        return this.bucket;
    }

    public int getMessageSizeThreshold() {
        return this.messageSizeThreshold;
    }

    public DataUnit getMessageSizeThresholdUnit() {
        return this.messageSizeThresholdUnit;
    }

    public String getCustomS3Endpoint() {
        return this.customS3Endpoint;
    }

    @ExcludeFromGeneratedCoverage
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @ExcludeFromGeneratedCoverage
    public void setMessageSizeThreshold(int messageSizeThreshold) {
        this.messageSizeThreshold = messageSizeThreshold;
    }

    @ExcludeFromGeneratedCoverage
    public void setMessageSizeThresholdUnit(DataUnit messageSizeThresholdUnit) {
        this.messageSizeThresholdUnit = messageSizeThresholdUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setCustomS3Endpoint(String customS3Endpoint) {
        this.customS3Endpoint = customS3Endpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LargePayloadSupport that = (LargePayloadSupport)o;
        return this.messageSizeThreshold == that.messageSizeThreshold && Objects.equals(this.bucket, that.bucket) && this.messageSizeThresholdUnit == that.messageSizeThresholdUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.messageSizeThreshold, this.messageSizeThresholdUnit});
    }
}

