/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.sqs.internal.error.SQSErrorType;
import org.mule.extension.sqs.internal.error.SQSExceptionHandler;
import org.mule.extension.sqs.internal.error.exception.MissingTestQueueArnException;
import org.mule.extension.sqs.internal.error.exception.S3BucketAccessDeniedException;
import org.mule.extension.sqs.internal.error.exception.S3BucketNotFoundException;
import org.mule.extension.sqs.internal.error.exception.SQSRuntimeException;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;

public class SQSConnection
implements ConnectorConnection {
    private final String testQueueName;
    private final SqsClient sqsClient;

    public SQSConnection(SqsClient client, String testQueueName) {
        this.sqsClient = client;
        this.testQueueName = testQueueName;
    }

    public void disconnect() {
        this.sqsClient.close();
    }

    public void validate() {
        if (this.testQueueName == null) {
            throw new MissingTestQueueArnException(SQSErrorType.INVALID_DATA);
        }
        try {
            this.sqsClient.getQueueUrl((GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(this.testQueueName).build());
        }
        catch (AwsServiceException | SdkClientException e) {
            throw SQSExceptionHandler.wrapException((Exception)e);
        }
    }

    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) {
        return this.sqsClient.addPermission(addPermissionRequest);
    }

    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).changeMessageVisibility(arg_0), changeMessageVisibilityRequest);
    }

    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).changeMessageVisibilityBatch(arg_0), changeMessageVisibilityBatchRequest);
    }

    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) {
        return this.sqsClient.createQueue(createQueueRequest);
    }

    public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).deleteMessage(arg_0), deleteMessageRequest);
    }

    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).deleteMessageBatch(arg_0), deleteMessageBatchRequest);
    }

    public DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        return this.sqsClient.deleteQueue(deleteQueueRequest);
    }

    public GetQueueUrlResponse getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        return this.sqsClient.getQueueUrl(getQueueUrlRequest);
    }

    public ListDeadLetterSourceQueuesResponse listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        return this.sqsClient.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) {
        return this.sqsClient.listQueues(listQueuesRequest);
    }

    public PurgeQueueResponse purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        return this.sqsClient.purgeQueue(purgeQueueRequest);
    }

    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) {
        return this.sqsClient.removePermission(removePermissionRequest);
    }

    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).sendMessage(arg_0), sendMessageRequest);
    }

    public SendMessageBatchResponse sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.invoke(client -> client.sendMessageBatch((SendMessageBatchRequest)SendMessageBatchRequest.builder().queueUrl(queueUrl).entries((Collection)entries).build()), this.sqsClient);
    }

    public SetQueueAttributesResponse setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        return this.sqsClient.setQueueAttributes(setQueueAttributesRequest);
    }

    public GetQueueAttributesResponse getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        return this.sqsClient.getQueueAttributes(getQueueAttributesRequest);
    }

    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        return this.invoke(arg_0 -> ((SqsClient)this.sqsClient).receiveMessage(arg_0), receiveMessageRequest);
    }

    private <T, R> R invoke(Function<T, R> function, T param) {
        try {
            return function.apply(param);
        }
        catch (SdkException e) {
            if (e.getCause() instanceof S3Exception) {
                S3Exception amazonS3Exception = (S3Exception)e.getCause();
                switch (amazonS3Exception.statusCode()) {
                    case 403: {
                        throw new S3BucketAccessDeniedException(amazonS3Exception.getMessage(), SQSErrorType.S3_BUCKET_ACCESS_DENIED);
                    }
                    case 404: {
                        throw new S3BucketNotFoundException(amazonS3Exception.getMessage(), SQSErrorType.S3_BUCKET_NOT_FOUND);
                    }
                }
                throw new SQSRuntimeException((Throwable)amazonS3Exception);
            }
            throw e;
        }
    }
}

