/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClient;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.sqs.api.LargePayloadSupport;
import org.mule.extension.sqs.api.utility.DataUnit;
import org.mule.extension.sqs.internal.connection.SQSConnection;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.extension.sqs.internal.connection.provider.group.ProxyParameterGroup;
import org.mule.extension.sqs.internal.error.SQSErrorType;
import org.mule.extension.sqs.internal.error.exception.MessageThresholdOutOfRangeException;
import org.mule.extension.sqs.internal.error.exception.SQSRuntimeException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public abstract class AbstractConnectionProvider
extends ConnectorConnectionProvider<SQSConnection>
implements CachedConnectionProvider<SQSConnection>,
Initialisable {
    @Parameter
    @DisplayName(value="Test Queue ARN")
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=3)
    @Summary(value="This parameter is used to test connection to SQS connector. If you do not specify this parameter the test connection is not performed. A queue ARN is constructed in the following format: arn:aws:{REGION}:{ACCOUNT_NUMBER}:{QUEUE_NAME}. Example: arn:aws:sqs:us-east-1:123456789101:test-queue")
    private String testQueueArn;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="Large Payload Support")
    @Placement(order=1, tab="Advanced")
    private LargePayloadSupport largePayloadSupport;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private CommonParameters commonParameters;
    @ParameterGroup(name="Proxy")
    @Placement(order=1)
    private ProxyParameterGroup proxyParameterGroup;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.commonParameters.getTlsContext());
    }

    public SQSConnection connect() throws ConnectionException {
        try {
            SqsClientBuilder sqsClientBuilder = (SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().httpClientBuilder((SdkHttpClient.Builder)this.getHttpClientBuilder())).checksumValidationEnabled(Boolean.valueOf(false));
            String formattedRegion = this.commonParameters.getRegion().toLowerCase().replace('_', '-');
            if (this.commonParameters.getCustomSqsEndpoint() != null) {
                ((SqsClientBuilder)sqsClientBuilder.region(Region.of((String)formattedRegion))).endpointOverride(URI.create(this.commonParameters.getCustomSqsEndpoint()));
            } else {
                sqsClientBuilder.region(Region.of((String)formattedRegion));
            }
            if (this.commonParameters.isTryDefaultAWSCredentialsProviderChain() || Optional.ofNullable(this.commonParameters.getAccessKey()).filter(Predicate.isEqual("").negate()).isPresent() && Optional.ofNullable(this.commonParameters.getSecretKey()).filter(Predicate.isEqual("").negate()).isPresent()) {
                sqsClientBuilder.credentialsProvider(this.getAWSCredentialsProvider(this.commonParameters));
                ExtendedClientConfiguration extendedClientConfiguration = new ExtendedClientConfiguration();
                if (this.largePayloadSupport != null) {
                    S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)this.getHttpClientBuilder())).credentialsProvider(this.getAWSCredentialsProvider(this.commonParameters))).region(Region.of((String)formattedRegion))).requestChecksumCalculation(RequestChecksumCalculation.WHEN_REQUIRED)).responseChecksumValidation(ResponseChecksumValidation.WHEN_REQUIRED);
                    if (this.largePayloadSupport.getCustomS3Endpoint() != null) {
                        s3ClientBuilder.endpointOverride(URI.create(this.largePayloadSupport.getCustomS3Endpoint()));
                    }
                    extendedClientConfiguration.withPayloadSupportEnabled((S3Client)s3ClientBuilder.build(), this.largePayloadSupport.getBucket()).withPayloadSizeThreshold(this.getMessageSizeThresholdInBytes(this.largePayloadSupport.getMessageSizeThresholdUnit(), this.largePayloadSupport.getMessageSizeThreshold()));
                }
                return new SQSConnection((SqsClient)new AmazonSQSExtendedClient((SqsClient)sqsClientBuilder.build(), extendedClientConfiguration), this.parseTestQueueName(this.testQueueArn));
            }
            throw new SQSRuntimeException("Access Key or Secret Key is blank");
        }
        catch (KeyManagementException | NoSuchAlgorithmException | SQSRuntimeException e) {
            throw new ConnectionException(((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    protected abstract AwsCredentialsProvider getAWSCredentialsProvider(CommonParameters var1) throws ConnectionException;

    protected ApacheHttpClient.Builder getHttpClientBuilder() throws NoSuchAlgorithmException, KeyManagementException {
        ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("http://" + this.proxyParameterGroup.getProxyHost() + ":" + this.proxyParameterGroup.getProxyPort())).username(this.proxyParameterGroup.getProxyUsername()).password(this.proxyParameterGroup.getProxyPassword()).ntlmDomain(this.proxyParameterGroup.getProxyDomain()).ntlmWorkstation(this.proxyParameterGroup.getProxyWorkstation()).build();
        SSLContext sslContext = this.commonParameters.getTlsContext() != null ? this.commonParameters.getTlsContext().createSslContext() : null;
        SSLConnectionSocketFactory socketFactory = null;
        if (sslContext != null) {
            SSLEngine sslEngine = sslContext.createSSLEngine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
            socketFactory = new SSLConnectionSocketFactory(sslContext, null, null, (HostnameVerifier)hostnameVerifier);
        }
        Integer maxConnections = this.commonParameters.getMaxConnections() > 0 ? Integer.valueOf(this.commonParameters.getMaxConnections()) : null;
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(proxyConfiguration).socketTimeout(Duration.ofMillis(this.commonParameters.getSocketTimeoutInMillis())).connectionTimeout(Duration.ofMillis(this.commonParameters.getConnectionTimeoutInMillis())).socketFactory(socketFactory).maxConnections(maxConnections);
        return httpClientBuilder;
    }

    private int getMessageSizeThresholdInBytes(DataUnit messageSizeThresholdUnit, int messageSizeThreshold) {
        if (messageSizeThreshold <= 0) {
            throw new MessageThresholdOutOfRangeException(SQSErrorType.MESSAGE_SIZE_THRESHOLD_OUT_OF_RANGE);
        }
        switch (messageSizeThresholdUnit) {
            case BYTE: {
                if (messageSizeThreshold <= 262144) {
                    return messageSizeThreshold;
                }
                throw new MessageThresholdOutOfRangeException(SQSErrorType.MESSAGE_SIZE_THRESHOLD_OUT_OF_RANGE);
            }
            case KB: {
                if (messageSizeThreshold <= 256) {
                    return messageSizeThreshold * 1024;
                }
                throw new MessageThresholdOutOfRangeException(SQSErrorType.MESSAGE_SIZE_THRESHOLD_OUT_OF_RANGE);
            }
        }
        throw new MessageThresholdOutOfRangeException(SQSErrorType.MESSAGE_SIZE_THRESHOLD_OUT_OF_RANGE);
    }

    public String parseTestQueueName(String testQueueArn) {
        int lastColon;
        if (testQueueArn != null && (lastColon = testQueueArn.lastIndexOf(58)) != -1) {
            return testQueueArn.substring(lastColon + 1);
        }
        return null;
    }
}

