/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.mule.extension.sqs.internal.connection.provider.AbstractConnectionProvider;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

@Alias(value="role")
public class AssumeRoleConnectionProvider
extends AbstractConnectionProvider {
    @Parameter
    @DisplayName(value="Role ARN")
    @Summary(value="The Role ARN unique identifies role to assume in order to gain cross account access.")
    @Placement(order=1)
    private String roleARN;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="External ID")
    @Summary(value="A unique identifier that might be required when you assume a role in another account. If the administrator of the account to which the role belongs provides an external ID, then provide that value in this field.")
    private String externalId;
    @Parameter
    @DisplayName(value="Custom STS Endpoint")
    @Optional
    @Placement(tab="Advanced", order=1)
    @Summary(value="Sets a custom STS endpoint. Useful when a non-standard service endpoint is required, such as a VPC endpoint.")
    @ExcludeFromConnectivitySchema
    private String customStsEndpoint;

    @Override
    protected AwsCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) throws ConnectionException {
        try {
            String formattedRegion = commonParameters.getRegion().toLowerCase().replace('_', '-');
            DefaultCredentialsProvider credentialsProvider = commonParameters.isTryDefaultAWSCredentialsProviderChain() ? DefaultCredentialsProvider.create() : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)commonParameters.getAccessKey(), (String)commonParameters.getSecretKey()));
            AssumeRoleRequest assumeRoleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleARN).roleSessionName("mule-sqs-connector-role-" + UUID.randomUUID()).externalId(this.externalId).build();
            StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).httpClientBuilder((SdkHttpClient.Builder)this.getHttpClientBuilder())).region(Region.of((String)formattedRegion));
            if (this.customStsEndpoint != null) {
                stsClientBuilder.endpointOverride(URI.create(this.customStsEndpoint));
            }
            return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient((StsClient)stsClientBuilder.build())).refreshRequest(assumeRoleRequest).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

