/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider;

import org.mule.extension.sqs.internal.connection.provider.AbstractConnectionProvider;
import org.mule.extension.sqs.internal.connection.provider.group.CommonParameters;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.SecurityToken;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

@Alias(value="basic")
public class BasicConnectionProvider
extends AbstractConnectionProvider {
    @Parameter
    @DisplayName(value="Session Token")
    @Placement(order=1)
    @Optional
    @Summary(value="The session token provided by Amazon STS.")
    @SecurityToken
    private String sessionToken;

    @Override
    protected AwsCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) {
        if (commonParameters.isTryDefaultAWSCredentialsProviderChain()) {
            return DefaultCredentialsProvider.create();
        }
        if (StringUtils.isBlank((String)this.sessionToken)) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)commonParameters.getAccessKey(), (String)commonParameters.getSecretKey()));
        }
        return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)commonParameters.getAccessKey(), (String)commonParameters.getSecretKey(), (String)this.sessionToken));
    }
}

