/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.connection.provider.group;

import java.util.concurrent.TimeUnit;
import org.mule.extension.sqs.internal.util.RegionValuesProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.security.Username;

public class CommonParameters {
    @Parameter
    @DisplayName(value="Access Key")
    @Placement(order=1)
    @Summary(value="The access key provided by Amazon.")
    @Username
    private String accessKey;
    @Parameter
    @DisplayName(value="Secret Key")
    @Placement(order=2)
    @Summary(value="The secret key provided by Amazon.")
    @Password
    private String secretKey;
    @Parameter
    @DisplayName(value="Try Default AWSCredentials Provider Chain")
    @Placement(order=3)
    @Optional
    @Summary(value="Set this field to true to obtain credentials from the AWS environment, See: https://docs.aws.amazon.com/sdk-for-java/v2/developer-guide/credentials.html")
    @ExcludeFromConnectivitySchema
    private boolean tryDefaultAWSCredentialsProviderChain;
    @OfValues(value=RegionValuesProvider.class)
    @Optional(defaultValue="us-east-1")
    @Parameter
    @DisplayName(value="Region Endpoint")
    @Placement(order=4)
    @Summary(value="Set the topic region endpoint.")
    private String region;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Security", order=1)
    @Parameter
    @Optional
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContext;
    @Parameter
    @DisplayName(value="Custom SQS Endpoint")
    @Optional
    @Placement(tab="Advanced", order=1)
    @Summary(value="Sets a custom SQS endpoint. Useful when a non-standard service endpoint is required, such as a VPC endpoint.")
    @ExcludeFromConnectivitySchema
    private String customSqsEndpoint;
    @Parameter
    @Optional(defaultValue="50000")
    @Placement(tab="Advanced", order=2)
    @DisplayName(value="Connection Timeout")
    @Summary(value="The amount of time to wait (in milliseconds) when initially establishing a connection before the connector gives up and times out. A value of 0 means infinity and is not recommended.")
    @ExcludeFromConnectivitySchema
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=3)
    @Summary(value="Time unit used in the connection timeout configurations.")
    @ExcludeFromConnectivitySchema
    private TimeUnit connectionTimeoutUnit;
    @Parameter
    @Optional
    @Placement(tab="Advanced", order=4)
    @Summary(value="Sets the maximum number of allowed open HTTP connections.")
    @ExcludeFromConnectivitySchema
    private int maxConnections;
    @Parameter
    @Optional(defaultValue="50000")
    @Placement(tab="Advanced", order=5)
    @DisplayName(value="Socket Timeout")
    @Summary(value="The amount of time to wait (in milliseconds) for data to be transferred over an established, open connection before the connection times out. A value of 0 means infinity and is not recommended.")
    @ExcludeFromConnectivitySchema
    private int socketTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=6)
    @Summary(value="Time unit used in the socket timeout configurations.")
    @ExcludeFromConnectivitySchema
    private TimeUnit socketTimeoutUnit;

    public int getConnectionTimeoutInMillis() {
        return Math.toIntExact(this.connectionTimeoutUnit.toMillis(this.connectionTimeout));
    }

    public int getSocketTimeoutInMillis() {
        return Math.toIntExact(this.socketTimeoutUnit.toMillis(this.socketTimeout));
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isTryDefaultAWSCredentialsProviderChain() {
        return this.tryDefaultAWSCredentialsProviderChain;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCustomSqsEndpoint() {
        return this.customSqsEndpoint;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }
}

