/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.error;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.mule.extension.sqs.internal.error.AccessDeniedErrorCodes;
import org.mule.extension.sqs.internal.error.InvalidCredentials;
import org.mule.extension.sqs.internal.error.InvalidDataErrorCodes;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;

public enum SQSErrorType implements ErrorTypeDefinition<SQSErrorType>
{
    CONNECTIVITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.CONNECTIVITY),
    SECURITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.SECURITY),
    INVALID_DATA(InvalidDataErrorCodes.getErrorCodes()),
    ACCESS_DENIED(SECURITY, AccessDeniedErrorCodes.getErrorCodes()),
    INTERNAL_FAILURE,
    INVALID_CREDENTIALS(SECURITY, InvalidCredentials.getErrorCodes()),
    INVALID_URL((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.VALIDATION),
    OPT_IN_REQUIRED(SECURITY),
    REQUEST_EXPIRED(SECURITY),
    SERVICE_UNAVAILABLE,
    THROTTLING_EXCEPTION,
    MESSAGE_NOT_IN_FLIGHT(Collections.singleton("AWS_SIMPLE_QUEUE_SERVICE_MESSAGE_NOT_IN_FLIGHT")),
    PURGE_QUEUE_IN_PROGRESS(Collections.singleton("AWS_SIMPLE_QUEUE_SERVICE_PURGE_QUEUE_IN_PROGRESS")),
    QUEUE_DELETED_RECENTLY(Collections.singleton("AWS_SIMPLE_QUEUE_SERVICE_QUEUE_DELETED_RECENTLY")),
    OVER_LIMIT,
    QUEUE_ALREADY_EXISTS,
    MESSAGE_SIZE_THRESHOLD_OUT_OF_RANGE(INVALID_DATA),
    PARAMETER_OUT_OF_RANGE(INVALID_DATA),
    S3_BUCKET_ACCESS_DENIED(ACCESS_DENIED),
    S3_BUCKET_NOT_FOUND;

    private final Set<String> errorCodes;
    private final ErrorTypeDefinition<? extends Enum<?>> parent;

    private SQSErrorType() {
        this.errorCodes = Collections.emptySet();
        this.parent = null;
    }

    private SQSErrorType(ErrorTypeDefinition<? extends Enum<?>> parent) {
        this.errorCodes = Collections.emptySet();
        this.parent = parent;
    }

    private SQSErrorType(Set<String> errorCodes) {
        this.errorCodes = errorCodes;
        this.parent = null;
    }

    private SQSErrorType(ErrorTypeDefinition<? extends Enum<?>> parent, Set<String> errorCodes) {
        this.parent = parent;
        this.errorCodes = errorCodes;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Set<String> getErrorCodes() {
        return this.errorCodes;
    }
}

