/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.operation;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.sqs.api.model.BatchResult;
import org.mule.extension.sqs.api.model.Message;
import org.mule.extension.sqs.api.model.MessageAttributeValue;
import org.mule.extension.sqs.api.model.SendMessageResult;
import org.mule.runtime.core.api.util.IOUtils;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;

public class SQSModelFactory {
    private SQSModelFactory() {
    }

    public static org.mule.extension.sqs.api.model.BatchResultErrorEntry transform(BatchResultErrorEntry awsBatchResultErrorEntry) {
        return new org.mule.extension.sqs.api.model.BatchResultErrorEntry(awsBatchResultErrorEntry.id(), awsBatchResultErrorEntry.senderFault(), awsBatchResultErrorEntry.code(), awsBatchResultErrorEntry.message());
    }

    public static List<ChangeMessageVisibilityBatchRequestEntry> getChangeMessageVisibilityBatchRequestEntries(List<org.mule.extension.sqs.api.model.ChangeMessageVisibilityBatchRequestEntry> requestEntries) {
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> awsRequestEntries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>();
        if (requestEntries != null && !requestEntries.isEmpty()) {
            for (org.mule.extension.sqs.api.model.ChangeMessageVisibilityBatchRequestEntry requestEntry : requestEntries) {
                ChangeMessageVisibilityBatchRequestEntry awsRequestEntry = (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(requestEntry.getId()).receiptHandle(requestEntry.getReceiptHandle()).visibilityTimeout(requestEntry.getVisibilityTimeout()).build();
                awsRequestEntries.add(awsRequestEntry);
            }
        }
        return awsRequestEntries;
    }

    public static List<DeleteMessageBatchRequestEntry> getDeleteMessageBatchRequestEntries(List<org.mule.extension.sqs.api.model.DeleteMessageBatchRequestEntry> requestEntries) {
        ArrayList<DeleteMessageBatchRequestEntry> awsRequestEntries = new ArrayList<DeleteMessageBatchRequestEntry>();
        if (requestEntries != null && !requestEntries.isEmpty()) {
            for (org.mule.extension.sqs.api.model.DeleteMessageBatchRequestEntry requestEntry : requestEntries) {
                DeleteMessageBatchRequestEntry awsRequestEntry = (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(requestEntry.getId()).receiptHandle(requestEntry.getReceiptHandle()).build();
                awsRequestEntries.add(awsRequestEntry);
            }
        }
        return awsRequestEntries;
    }

    public static Map<String, software.amazon.awssdk.services.sqs.model.MessageAttributeValue> getMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        HashMap<String, software.amazon.awssdk.services.sqs.model.MessageAttributeValue> awsMessageAttributes = new HashMap<String, software.amazon.awssdk.services.sqs.model.MessageAttributeValue>();
        if (messageAttributes != null && !messageAttributes.isEmpty()) {
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                MessageAttributeValue attributeValue = entry.getValue();
                software.amazon.awssdk.services.sqs.model.MessageAttributeValue awsMsgAttributeValue = (software.amazon.awssdk.services.sqs.model.MessageAttributeValue)software.amazon.awssdk.services.sqs.model.MessageAttributeValue.builder().dataType(attributeValue.getDataType()).stringValue(attributeValue.getStringValue()).binaryValue((SdkBytes)Optional.ofNullable(attributeValue.getBinaryValue()).map(IOUtils::toByteArray).map(SdkBytes::fromByteArray).orElse(null)).build();
                awsMessageAttributes.put(entry.getKey(), awsMsgAttributeValue);
            }
        }
        return awsMessageAttributes;
    }

    public static SendMessageResult getSendMessageResult(String messageId, String md5OfMessageBody, String md5OfMessageAttributes) {
        return new SendMessageResult(md5OfMessageBody, md5OfMessageAttributes, messageId);
    }

    public static List<SendMessageBatchRequestEntry> getSendMessageBatchRequestEntries(List<Message> messages) {
        return Optional.ofNullable(messages).orElseGet(ArrayList::new).stream().map(message -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().delaySeconds(message.getDelaySeconds()).id(message.getId()).messageAttributes(SQSModelFactory.getMessageAttributes(message.getMessageAttributes())).messageBody(message.getBody()).messageGroupId(message.getGroupId()).messageDeduplicationId(message.getDeduplicationId()).build()).collect(Collectors.toList());
    }

    public static BatchResult getSendMessageBatchResult(SendMessageBatchResponse batchResult) {
        List<String> successEntryIds = Collections.emptyList();
        if (batchResult.successful() != null && !batchResult.successful().isEmpty()) {
            successEntryIds = new ArrayList();
            for (SendMessageBatchResultEntry awsBatchResultEntry : batchResult.successful()) {
                successEntryIds.add(awsBatchResultEntry.id());
            }
        }
        List<org.mule.extension.sqs.api.model.BatchResultErrorEntry> batchResultErrorEntries = Collections.emptyList();
        return new BatchResult(successEntryIds, SQSModelFactory.getBatchResultErrorEntries(batchResult.failed(), batchResultErrorEntries));
    }

    private static List<org.mule.extension.sqs.api.model.BatchResultErrorEntry> getBatchResultErrorEntries(List<BatchResultErrorEntry> awsBatchResultErrorEntries, List<org.mule.extension.sqs.api.model.BatchResultErrorEntry> batchResultErrorEntries) {
        if (awsBatchResultErrorEntries != null && !awsBatchResultErrorEntries.isEmpty()) {
            batchResultErrorEntries = new ArrayList<org.mule.extension.sqs.api.model.BatchResultErrorEntry>(awsBatchResultErrorEntries.size());
            for (BatchResultErrorEntry batchResultErrorEntry : awsBatchResultErrorEntries) {
                batchResultErrorEntries.add(SQSModelFactory.transform(batchResultErrorEntry));
            }
        }
        return batchResultErrorEntries;
    }

    public static Map<String, Object> wrapMessageAttributes(software.amazon.awssdk.services.sqs.model.Message awsMessage) {
        HashMap<String, Object> properties = new HashMap<String, Object>(awsMessage.attributesAsStrings());
        properties.put("sqs.message.id", awsMessage.messageId());
        properties.put("sqs.message.receipt.handle", awsMessage.receiptHandle());
        properties.putAll(SQSModelFactory.getSqsMessageAttributes(awsMessage));
        return properties;
    }

    public static Message wrapMessage(software.amazon.awssdk.services.sqs.model.Message message) {
        return new Message(message.messageId(), message.receiptHandle(), message.body(), null, null, null, SQSModelFactory.getSqsMessageAttributes(message));
    }

    private static Map<String, MessageAttributeValue> getSqsMessageAttributes(software.amazon.awssdk.services.sqs.model.Message message) {
        Map awsMessageAttributes = message.messageAttributes();
        HashMap<String, MessageAttributeValue> finalAttributes = new HashMap<String, MessageAttributeValue>(awsMessageAttributes.size());
        if (awsMessageAttributes.size() > 0) {
            awsMessageAttributes.forEach((key, value) -> {
                MessageAttributeValue attributeValue = new MessageAttributeValue(value.stringValue(), (InputStream)new ByteBufferBackedInputStream((ByteBuffer)Optional.ofNullable(value.binaryValue()).map(BytesWrapper::asByteBuffer).orElse(null)), value.dataType());
                finalAttributes.put((String)key, attributeValue);
            });
        }
        return finalAttributes;
    }
}

