/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.mule.extension.sqs.api.attributes.RequestIDAttribute;
import org.mule.extension.sqs.api.model.BatchResult;
import org.mule.extension.sqs.api.model.ChangeMessageVisibilityBatchRequestEntry;
import org.mule.extension.sqs.api.model.DeleteMessageBatchRequestEntry;
import org.mule.extension.sqs.api.model.Message;
import org.mule.extension.sqs.api.model.SendMessageResult;
import org.mule.extension.sqs.internal.config.SQSConfiguration;
import org.mule.extension.sqs.internal.connection.SQSConnection;
import org.mule.extension.sqs.internal.error.SQSErrorType;
import org.mule.extension.sqs.internal.error.exception.WaitTimeOutOfRangeException;
import org.mule.extension.sqs.internal.error.provider.AddPermissionErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.ChangeMessageVisibilityErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.CommonErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.CreateQueueErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.LargePayloadErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.PurgeQueueErrorTypeProvider;
import org.mule.extension.sqs.internal.error.provider.ReadErrorTypeProvider;
import org.mule.extension.sqs.internal.operation.SQSModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

public class SQSOperations {
    @MediaType(value="text/plain")
    @Throws(value={AddPermissionErrorTypeProvider.class})
    public String addPermission(@Config SQSConfiguration config, @Connection SQSConnection client, String label, List<String> accountIds, List<String> actions, @Summary(value="Permissions will be added to the queue represented by this URL. This parameter is optional, and if you do not specify queueUrl, you must specify the default global queue URL at the configuration level.") @Optional String queueUrl) {
        return client.addPermission((AddPermissionRequest)AddPermissionRequest.builder().queueUrl(config.getUrl(queueUrl)).label(label).awsAccountIds(accountIds).actions(actions).build()).responseMetadata().requestId();
    }

    @MediaType(value="text/plain")
    @Throws(value={ChangeMessageVisibilityErrorTypeProvider.class})
    public String changeMessageVisibility(@Config SQSConfiguration config, @Connection SQSConnection client, @Optional @Example(value="#[header:inbound:sqs.message.receipt.handle]") String receiptHandle, Integer visibilityTimeout, @Optional(defaultValue="SECONDS") TimeUnit visibilityTimeoutUnit, @Summary(value="The URL of the Amazon SQS queue to take action on. This parameter is optional, and if you do not specify queueUrl, you must specify the Default Global Queue URL at the configuration level.") @Optional String queueUrl) {
        return client.changeMessageVisibility((ChangeMessageVisibilityRequest)ChangeMessageVisibilityRequest.builder().queueUrl(config.getUrl(queueUrl)).receiptHandle(receiptHandle).visibilityTimeout(Integer.valueOf(Math.toIntExact(visibilityTimeoutUnit.toSeconds(visibilityTimeout.intValue())))).build()).responseMetadata().requestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> changeMessageVisibilityBatch(@Config SQSConfiguration config, @Connection SQSConnection client, @Content List<ChangeMessageVisibilityBatchRequestEntry> receiptHandles, @Summary(value="The URL of the Amazon SQS queue to take action on. This parameter is optional, and if you do not specify queueUrl, you must specify the Default Global Queue URL at the configuration level.") @Optional String queueUrl) {
        ChangeMessageVisibilityBatchResponse batchResult = client.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)ChangeMessageVisibilityBatchRequest.builder().queueUrl(config.getUrl(queueUrl)).entries(SQSModelFactory.getChangeMessageVisibilityBatchRequestEntries(receiptHandles)).build());
        BatchResult result = new BatchResult(batchResult.successful().stream().map(ChangeMessageVisibilityBatchResultEntry::id).collect(Collectors.toList()), batchResult.failed().stream().map(SQSModelFactory::transform).collect(Collectors.toList()));
        return this.getResult(result, (AwsResponse)batchResult);
    }

    @MediaType(value="text/plain")
    @Throws(value={CreateQueueErrorTypeProvider.class})
    public Result<String, RequestIDAttribute> createQueue(@Connection SQSConnection client, String queueName, @NullSafe @Optional @Content Map<String, String> attributes) {
        CreateQueueResponse result = client.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).attributesWithStrings(attributes).build());
        return this.getResult(result.queueUrl(), (AwsResponse)result, org.mule.runtime.api.metadata.MediaType.TEXT);
    }

    @MediaType(value="text/plain")
    @Throws(value={LargePayloadErrorTypeProvider.class})
    public String deleteMessage(@Config SQSConfiguration config, @Connection SQSConnection client, String receiptHandle, @Summary(value="URL of the queue to delete messages from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.deleteMessage((DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(config.getUrl(queueUrl)).receiptHandle(receiptHandle).build()).responseMetadata().requestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> deleteMessageBatch(@Config SQSConfiguration config, @Connection SQSConnection client, List<DeleteMessageBatchRequestEntry> entries, @Summary(value="URL of the queue to delete messages as a batch from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        DeleteMessageBatchResponse batchResult = client.deleteMessageBatch((DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(config.getUrl(queueUrl)).entries(SQSModelFactory.getDeleteMessageBatchRequestEntries(entries)).build());
        BatchResult result = new BatchResult(batchResult.successful().stream().map(DeleteMessageBatchResultEntry::id).collect(Collectors.toList()), batchResult.failed().stream().map(SQSModelFactory::transform).collect(Collectors.toList()));
        return this.getResult(result, (AwsResponse)batchResult);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String deleteQueue(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="URL of the queue to delete. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(config.getUrl(queueUrl)).build()).responseMetadata().requestId();
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<Map<String, String>, RequestIDAttribute> getQueueAttributes(@Config SQSConfiguration config, @Connection SQSConnection client, @Optional @NullSafe List<String> attributeNames, @Summary(value="URL of the Amazon SQS queue to take action on This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        GetQueueAttributesResponse queueAttributes = client.getQueueAttributes((GetQueueAttributesRequest)GetQueueAttributesRequest.builder().queueUrl(config.getUrl(queueUrl)).attributeNamesWithStrings(attributeNames).build());
        return this.getResult(queueAttributes.attributesAsStrings(), (AwsResponse)queueAttributes);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public Result<String, RequestIDAttribute> getQueueUrl(@Connection SQSConnection client, String queueName, @Optional String queueOwnerAWSAccountId) {
        GetQueueUrlResponse result = client.getQueueUrl((GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).queueOwnerAWSAccountId(queueOwnerAWSAccountId).build());
        return this.getResult(result.queueUrl(), (AwsResponse)result, org.mule.runtime.api.metadata.MediaType.TEXT);
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<List<String>, RequestIDAttribute> listDeadLetterSourceQueues(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL of a dead-letter queue. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        ListDeadLetterSourceQueuesResponse result = client.listDeadLetterSourceQueues((ListDeadLetterSourceQueuesRequest)ListDeadLetterSourceQueuesRequest.builder().queueUrl(config.getUrl(queueUrl)).build());
        return this.getResult(result.queueUrls(), (AwsResponse)result);
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<List<String>, RequestIDAttribute> listQueues(@Connection SQSConnection client, @Optional String queueNamePrefix) {
        ListQueuesResponse result = client.listQueues((ListQueuesRequest)ListQueuesRequest.builder().queueNamePrefix(queueNamePrefix).build());
        return this.getResult(result.queueUrls(), (AwsResponse)result);
    }

    @MediaType(value="text/plain")
    @Throws(value={PurgeQueueErrorTypeProvider.class})
    public String purgeQueue(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL where messages are to be fetched from. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.purgeQueue((PurgeQueueRequest)PurgeQueueRequest.builder().queueUrl(config.getUrl(queueUrl)).build()).responseMetadata().requestId();
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String removePermission(@Config SQSConfiguration config, @Connection SQSConnection client, String label, @Summary(value="Permissions will be deleted from the queue represented by this URL This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.removePermission((RemovePermissionRequest)RemovePermissionRequest.builder().queueUrl(config.getUrl(queueUrl)).label(label).build()).responseMetadata().requestId();
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<SendMessageResult, RequestIDAttribute> sendMessage(@Config SQSConfiguration config, @Connection SQSConnection client, @Content Message message, @Summary(value="Queue where the message is to be sent. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        SendMessageResponse result = client.sendMessage((SendMessageRequest)SendMessageRequest.builder().queueUrl(config.getUrl(queueUrl)).messageBody(message.getBody()).delaySeconds(message.getDelaySeconds()).messageAttributes(SQSModelFactory.getMessageAttributes(message.getMessageAttributes())).messageDeduplicationId(message.getDeduplicationId()).messageGroupId(message.getGroupId()).build());
        SendMessageResult payload = new SendMessageResult(result.md5OfMessageBody(), result.md5OfMessageAttributes(), result.messageId());
        return this.getResult(payload, (AwsResponse)result);
    }

    @Throws(value={LargePayloadErrorTypeProvider.class})
    public Result<BatchResult, RequestIDAttribute> sendMessageBatch(@Config SQSConfiguration config, @Connection SQSConnection client, @Content List<Message> messages, @Summary(value="Queue where the message is to be sent. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        SendMessageBatchResponse result = client.sendMessageBatch(config.getUrl(queueUrl), SQSModelFactory.getSendMessageBatchRequestEntries(messages));
        return this.getResult(SQSModelFactory.getSendMessageBatchResult(result), (AwsResponse)result);
    }

    @MediaType(value="text/plain")
    @Throws(value={CommonErrorTypeProvider.class})
    public String setQueueAttributes(@Config SQSConfiguration config, @Connection SQSConnection client, @Content Map<String, String> attributes, @Summary(value="URL of the queue This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        return client.setQueueAttributes((SetQueueAttributesRequest)SetQueueAttributesRequest.builder().queueUrl(config.getUrl(queueUrl)).attributesWithStrings(attributes).build()).responseMetadata().requestId();
    }

    @Throws(value={CommonErrorTypeProvider.class})
    public Result<Integer, RequestIDAttribute> getApproximateNumberOfMessages(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="URL of the queue. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl) {
        GetQueueAttributesResponse result = client.getQueueAttributes((GetQueueAttributesRequest)GetQueueAttributesRequest.builder().queueUrl(config.getUrl(queueUrl)).attributeNamesWithStrings(new String[]{"ApproximateNumberOfMessages"}).build());
        return this.getResult(Integer.parseInt((String)result.attributes().get(QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES)), (AwsResponse)result);
    }

    @Throws(value={ReadErrorTypeProvider.class})
    public Result<List<Message>, RequestIDAttribute> read(@Config SQSConfiguration config, @Connection SQSConnection client, @Summary(value="Queue URL. This parameter is optional and if you do not specify queueUrl you need to set in the configuration level Default Global Queue URL.") @Optional String queueUrl, @Summary(value="Maximum duration of a single poll, in seconds. Valid values are from 0 to 20. Use 0 for short polling.") @Placement(tab="Advanced") @DisplayName(value="Wait time") @ConfigOverride int waitTime, int maxNumberOfMessages) {
        if (waitTime < 0 || waitTime > 20) {
            throw new WaitTimeOutOfRangeException(waitTime, SQSErrorType.PARAMETER_OUT_OF_RANGE);
        }
        ReceiveMessageRequest receiveMessageRequest = (ReceiveMessageRequest)ReceiveMessageRequest.builder().queueUrl(config.getUrl(queueUrl)).attributeNamesWithStrings(new String[]{"All"}).messageAttributeNames(new String[]{"All"}).maxNumberOfMessages(Integer.valueOf(maxNumberOfMessages)).waitTimeSeconds(Integer.valueOf(waitTime)).build();
        ReceiveMessageResponse result = client.receiveMessage(receiveMessageRequest);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (software.amazon.awssdk.services.sqs.model.Message message : result.messages()) {
            Message wrappedMessage = SQSModelFactory.wrapMessage(message);
            messages.add(wrappedMessage);
        }
        return this.getResult(messages, (AwsResponse)result);
    }

    private <T> Result<T, RequestIDAttribute> getResult(T payload, AwsResponse amazonWebServiceResult) {
        return this.getResult(payload, amazonWebServiceResult, null);
    }

    private <T> Result<T, RequestIDAttribute> getResult(T payload, AwsResponse amazonWebServiceResult, org.mule.runtime.api.metadata.MediaType mediaType) {
        return Result.builder().mediaType(mediaType).output(payload).attributes((Object)new RequestIDAttribute(amazonWebServiceResult.responseMetadata().requestId())).build();
    }
}

