/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.sqs.internal.source.params;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class PollingParameters {
    @Parameter
    @Optional(defaultValue="1000")
    @DisplayName(value="Frequency")
    @Placement(tab="Advanced", order=1)
    @Summary(value="Frequency at which the connector polls for incoming messages, in the time unit specified in the Time unit field. If you set this value to 0, the connector polls as fast as possible.")
    private long frequency;
    @Parameter
    @Optional(defaultValue="0")
    @DisplayName(value="Start delay")
    @Placement(tab="Advanced", order=2)
    @Summary(value="Amount of time for which the connector waits before it starts polling for incoming messages, in the time unit specified in the Time unit field. By default, the connector starts polling immediately.")
    private long startDelay;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @DisplayName(value="Time unit")
    @Placement(tab="Advanced", order=3)
    @Summary(value="Time unit for the Frequency and Start delay field values")
    private TimeUnit timeUnit;

    public int getFrequencyInMillis() {
        return Math.toIntExact(this.timeUnit.toMillis(this.frequency));
    }

    public int getStartDelayInMillis() {
        return Math.toIntExact(this.timeUnit.toMillis(this.startDelay));
    }
}

