/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal;

import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.exception.resolver.ExceptionResolver;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractExceptionResolver
implements ExceptionResolver {
    private Map<String, ExceptionResolver> resolvers = new HashMap<String, ExceptionResolver>();

    public AbstractExceptionResolver() {
        this.registerResolvers();
    }

    public abstract void registerResolvers();

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        String canonicalName = throwable.getClass().getCanonicalName();
        if (this.resolvers.containsKey(canonicalName)) {
            return this.resolvers.get(canonicalName).resolveException(throwable);
        }
        return new AmqpExtensionException(throwable.getMessage());
    }

    protected void registerResolver(String canonicalName, ExceptionResolver exceptionResolver) {
        this.resolvers.put(canonicalName, exceptionResolver);
    }
}

