/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpConsumeTimeoutException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpQueueNotFoundException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;

public class ConsumeShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        ShutdownSignalException exception = (ShutdownSignalException)throwable;
        if (exception.getReason().protocolMethodName().equals("channel.close")) {
            int replyCode = ((AMQImpl.Channel.Close)exception.getReason()).getReplyCode();
            if (replyCode == 408) {
                return new AmqpConsumeTimeoutException("A timeout was sent by the broker");
            }
            return super.resolveException(throwable);
        }
        return new AmqpExtensionException(exception.getMessage());
    }

    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpQueueNotFoundException(message);
    }
}

