/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExchangeNotFoundException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpUnroutableMessageException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;

public class PublishShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpExchangeNotFoundException(message);
    }

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        ShutdownSignalException exception = (ShutdownSignalException)throwable;
        if (exception.getReason().protocolMethodName().equals("channel.close")) {
            int replyCode = ((AMQImpl.Channel.Close)exception.getReason()).getReplyCode();
            if (replyCode == 312 || replyCode == 313) {
                return new AmqpUnroutableMessageException(exception.getMessage());
            }
            return super.resolveException(throwable);
        }
        return new AmqpExtensionException(exception.getMessage());
    }
}

