/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.exception.resolver.ExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;

public abstract class ShutdownSignalExceptionResolver
implements ExceptionResolver {
    public static final String CHANNEL_CLOSE = "channel.close";

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        int replyCode;
        ShutdownSignalException exception = (ShutdownSignalException)throwable;
        if (exception.getReason().protocolMethodName().equals(CHANNEL_CLOSE) && (replyCode = ((AMQImpl.Channel.Close)exception.getReason()).getReplyCode()) == 404) {
            return this.getResourceNotFoundException(exception.getMessage());
        }
        return new AmqpExtensionException(exception.getMessage());
    }

    abstract AmqpExtensionException getResourceNotFoundException(String var1);
}

