/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.listener;

import com.mule.extensions.amqp.internal.listener.MessageReceiverConsumer;
import com.rabbitmq.client.Channel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerManager.class);
    private List<ConsumerNode> consumers = new ArrayList<ConsumerNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Channel channel, String consumerTag, MessageReceiverConsumer messageReceiverConsumer) {
        List<ConsumerNode> list = this.consumers;
        synchronized (list) {
            this.consumers.add(new ConsumerNode(messageReceiverConsumer, channel, consumerTag));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConsumers() {
        List<ConsumerNode> list = this.consumers;
        synchronized (list) {
            try {
                this.consumers.forEach(consumer -> ConsumerManager.closeQuietly(consumer.getChannel()));
            }
            finally {
                this.consumers.clear();
            }
        }
    }

    public static void closeQuietly(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close amqp channel: ", (Throwable)e);
            }
        }
    }

    private class ConsumerNode {
        private MessageReceiverConsumer messageReceiverConsumer;
        private Channel channel;
        private String consumerTag;

        public ConsumerNode(MessageReceiverConsumer messageReceiverConsumer, Channel channel, String consumerTag) {
            this.messageReceiverConsumer = messageReceiverConsumer;
            this.channel = channel;
            this.consumerTag = consumerTag;
        }

        public MessageReceiverConsumer getMessageReceiverConsumer() {
            return this.messageReceiverConsumer;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }
    }
}

