/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.listener;

import com.mule.extensions.amqp.api.message.AmqpAttributes;
import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.config.InternalAckMode;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.listener.MultiChannelMessageSubReceiver;
import com.mule.extensions.amqp.internal.message.AmqpMessage;
import com.mule.extensions.amqp.internal.message.AmqpResultFactory;
import com.mule.extensions.amqp.internal.source.AmqpListenerLock;
import com.mule.extensions.amqp.internal.source.DefaultAmqpListenerLock;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageReceiverConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageReceiverConsumer.class);
    private final AmqpResultFactory resultFactory = new AmqpResultFactory();
    private final SourceCallback<InputStream, AmqpAttributes> sourceCallback;
    private final String inboundEncoding;
    private final String configEncoding;
    private final String inboundContentType;
    private final String configContentType;
    private final InternalAckMode ackMode;
    private final AmqpListenerLock listenerLock = new DefaultAmqpListenerLock();
    private AmqpChannelManager channelManager;
    private MultiChannelMessageSubReceiver multiChannelMessageSubReceiver;
    private AmqpTransactionalConnection amqpTransactionalConnection;

    public MessageReceiverConsumer(Channel channel, SourceCallback<InputStream, AmqpAttributes> sourceCallback, String inboundEncoding, String configEncoding, String inboundContentType, String configContentType, InternalAckMode ackMode, AmqpChannelManager channelManager, AmqpTransactionalConnection amqpTransactionalConnection, MultiChannelMessageSubReceiver multiChannelMessageSubReceiver) {
        super(channel);
        this.sourceCallback = sourceCallback;
        this.inboundEncoding = inboundEncoding;
        this.configEncoding = configEncoding;
        this.inboundContentType = inboundContentType;
        this.configContentType = configContentType;
        this.ackMode = ackMode;
        this.channelManager = channelManager;
        this.multiChannelMessageSubReceiver = multiChannelMessageSubReceiver;
        this.amqpTransactionalConnection = amqpTransactionalConnection;
    }

    public void handleCancel(String consumerTag) throws IOException {
        LOGGER.warn("Received external cancellation of consumer tag: " + consumerTag + ", the message receiver will try to restart.");
        this.multiChannelMessageSubReceiver.restart(false);
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        if (!sig.isHardError()) {
            LOGGER.warn("Received shutdown signal for consumer tag: " + consumerTag + ", the message receiver will try to restart.", (Throwable)sig);
            this.multiChannelMessageSubReceiver.restart(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.listenerLock.lock();
        try {
            SourceCallbackContext context = this.sourceCallback.createContext();
            context.addVariable("AMQP_CHANNEL", (Object)this.getChannel());
            context.addVariable("AMQP_DELIVERY_TAG", (Object)envelope.getDeliveryTag());
            context.addVariable("REPLY_TO_DESTINATION", (Object)properties.getReplyTo());
            context.bindConnection((Object)this.amqpTransactionalConnection);
            context.setCorrelationId(properties.getCorrelationId());
            AmqpMessage message = new AmqpMessage(consumerTag, envelope, AmqpCommons.getPropertiesFromBasicProperties(properties), properties.getHeaders(), body);
            String ackId = AmqpCommons.getMessageAckId(this.getChannel(), message.getEnvelope().getDeliveryTag());
            AmqpCommons.evaluateMessageAck(this.getChannel(), message, this.channelManager, this.ackMode, ackId);
            Result<InputStream, AmqpAttributes> result = this.resultFactory.createResult(message, AmqpCommons.resolveOverride(AmqpCommons.resolveMessageContentType(message, this.configContentType), this.inboundContentType), AmqpCommons.resolveOverride(AmqpCommons.resolveMessageEncoding(message, this.configEncoding), this.inboundEncoding), ackId);
            this.sourceCallback.handle(result, context);
        }
        catch (Exception e) {
            this.listenerLock.unlockWithFailure();
        }
        finally {
            if (this.listenerLock.isLocked()) {
                this.listenerLock.unlock();
            }
        }
    }
}

