/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.message;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpIllegalBodyException;
import com.mule.extensions.amqp.api.message.AmqpProperties;
import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.model.message.Message;
import com.rabbitmq.client.AMQP;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

public class AmqpMessageUtils {
    public static Message toMessage(TypedValue<Object> typedValueObject, AmqpProperties basicProperties, Map<String, Object> headers, boolean mandatory, boolean immediate, String routingKey, String exchange, String configContentType, String configEncoding, DeliveryMode deliveryMode, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo, TransformationService transformationService) throws AmqpExtensionException {
        Object object = typedValueObject.getValue();
        if (object == null) {
            throw new AmqpIllegalBodyException("Message body was 'null', which is not a value of a supported type");
        }
        AmqpMessageUtils.overrideEncoding(typedValueObject, basicProperties, configEncoding);
        AmqpMessageUtils.overrideContentType(typedValueObject, basicProperties, configContentType);
        AmqpMessageUtils.setAmqpCorrelationIdProperty(basicProperties, outboundCorrelationStrategy, correlationInfo);
        if (object instanceof Message) {
            return (Message)object;
        }
        byte[] body = (byte[])transformationService.transform(typedValueObject.getValue(), DataType.fromObject(typedValueObject), DataType.BYTE_ARRAY);
        return new Message(body, AmqpMessageUtils.getBasicPropertiesBuilder(basicProperties, headers, deliveryMode).build(), mandatory, immediate, routingKey == null ? "" : routingKey, exchange);
    }

    private static void overrideContentType(TypedValue<Object> typedValueObject, AmqpProperties basicProperties, String configContentType) {
        basicProperties.setContentType(AmqpCommons.resolveOverride(configContentType, typedValueObject.getDataType().getMediaType().toString()));
    }

    private static void overrideEncoding(TypedValue<Object> typedValueObject, AmqpProperties basicProperties, String configEncoding) {
        basicProperties.setEncoding(AmqpCommons.resolveOverride(configEncoding, typedValueObject.getDataType().getMediaType().getCharset().map(Charset::toString).orElse(basicProperties.getContentEncoding())));
    }

    private static AMQP.BasicProperties.Builder getBasicPropertiesBuilder(AmqpProperties properties, Map<String, Object> headers, DeliveryMode deliveryMode) {
        AMQP.BasicProperties.Builder bob = new AMQP.BasicProperties.Builder();
        bob.contentType(properties.getContentType()).contentEncoding(properties.getContentEncoding()).deliveryMode(deliveryMode.getCode()).priority(properties.getPriority()).correlationId(properties.getCorrelationId() == null ? UUID.randomUUID().toString() : properties.getCorrelationId()).replyTo(properties.getReplyTo()).userId(properties.getUserId()).expiration(properties.getExpiration() == null ? null : String.valueOf(properties.getExpirationTimeUnit().toMicros(properties.getExpiration().intValue()))).appId(properties.getAppId()).clusterId(properties.getClusterId());
        bob.headers(headers);
        return bob;
    }

    private static void setAmqpCorrelationIdProperty(AmqpProperties properties, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo) {
        outboundCorrelationStrategy.getOutboundCorrelationId(correlationInfo, properties.getCorrelationId()).ifPresent(id -> properties.setCorrelationId((String)id));
    }
}

