/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExchangeNotFoundException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpUnroutableMessageException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;

public class PublishShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpExchangeNotFoundException(message);
    }

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        if (this.reasonIsChannelClose(throwable)) {
            int replyCode = this.getReplyCode((ShutdownSignalException)throwable);
            if (replyCode == 312 || replyCode == 313) {
                return new AmqpUnroutableMessageException(throwable.getMessage());
            }
            return super.resolveException(throwable);
        }
        return new AmqpExtensionException(throwable.getMessage());
    }
}

