/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.listener;

import com.mule.extensions.amqp.api.config.ListenerQualityOfService;
import com.mule.extensions.amqp.api.message.AmqpAttributes;
import com.mule.extensions.amqp.internal.config.InternalAckMode;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.listener.ChannelReceiverManager;
import com.mule.extensions.amqp.internal.listener.ConsumerManager;
import com.mule.extensions.amqp.internal.listener.MultiChannelMessageSubReceiver;
import java.io.InputStream;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiChannelReceiverManager
implements ChannelReceiverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiChannelReceiverManager.class);
    private int numberOfConsumers;
    private AmqpTransactionalConnection connection;
    private InternalAckMode ackMode;
    private String queueName;
    private boolean noLocal;
    private boolean exclusiveConsumers;
    private String consumerTag;
    private String inboundContentType;
    private String configContentType;
    private String inboundEncoding;
    private String configEncoding;
    private SourceCallback<InputStream, AmqpAttributes> sourceCallback;
    private AmqpChannelManager channelManager;
    private ConsumerManager consumerManager;
    private SourceTransactionalAction transactionalAction;
    private ListenerQualityOfService qualityOfService;

    private MultiChannelReceiverManager(int numberOfConsumers, AmqpTransactionalConnection connection, InternalAckMode ackMode, String queueName, boolean noLocal, boolean exclusiveConsumers, String consumerTag, SourceCallback<InputStream, AmqpAttributes> sourceCallback, String inboundEncoding, String configEncoding, String inboundContentType, String configContentType, AmqpChannelManager channelManager, SourceTransactionalAction transactionalAction, ListenerQualityOfService qualityOfService, MuleContext muleContext) {
        this.numberOfConsumers = numberOfConsumers;
        this.connection = connection;
        this.ackMode = ackMode;
        this.queueName = queueName;
        this.noLocal = noLocal;
        this.exclusiveConsumers = exclusiveConsumers;
        this.consumerTag = consumerTag;
        this.sourceCallback = sourceCallback;
        this.inboundContentType = inboundContentType;
        this.configContentType = configContentType;
        this.inboundEncoding = inboundEncoding;
        this.configEncoding = configEncoding;
        this.channelManager = channelManager;
        this.transactionalAction = transactionalAction;
        this.qualityOfService = qualityOfService;
        this.consumerManager = new ConsumerManager(muleContext);
    }

    @Override
    public void start() throws ConnectionException {
        try {
            for (int i = 0; i < this.numberOfConsumers; ++i) {
                MultiChannelMessageSubReceiver sub = new MultiChannelMessageSubReceiver(this);
                sub.start();
            }
        }
        catch (Exception e) {
            String msg = "An error occurred while creating the consumers ";
            LOGGER.error(msg, (Throwable)e);
            this.consumerManager.releaseConsumers();
            throw new ConnectionException(msg, (Throwable)e, null, (Object)this.connection);
        }
    }

    @Override
    public void stop() {
        this.consumerManager.shutdown();
    }

    @Override
    public void restart() throws ConnectionException {
        this.stop();
        this.start();
    }

    public InternalAckMode getAckMode() {
        return this.ackMode;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public boolean isExclusiveConsumers() {
        return this.exclusiveConsumers;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public SourceCallback<InputStream, AmqpAttributes> getSourceCallback() {
        return this.sourceCallback;
    }

    public String getInboundContentType() {
        return this.inboundContentType;
    }

    public String getConfigContentType() {
        return this.configContentType;
    }

    public String getInboundEncoding() {
        return this.inboundEncoding;
    }

    public String getConfigEncoding() {
        return this.configEncoding;
    }

    public AmqpChannelManager getChannelManager() {
        return this.channelManager;
    }

    public SourceTransactionalAction getTransactionalAction() {
        return this.transactionalAction;
    }

    public AmqpTransactionalConnection getConnection() {
        return this.connection;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ListenerQualityOfService getQualityOfService() {
        return this.qualityOfService;
    }

    public void suspendConsumers() {
        this.consumerManager.suspendConsumers();
    }

    public static class Builder {
        private int numberOfConsumers;
        private AmqpTransactionalConnection connection;
        private InternalAckMode ackMode;
        private String queueName;
        private boolean noLocal;
        private boolean exclusiveConsumers;
        private String consumerTag;
        private String inboundContentType;
        private String configContentType;
        private String inboundEncoding;
        private String configEncoding;
        private SourceCallback<InputStream, AmqpAttributes> sourceCallback;
        private AmqpChannelManager channelManager;
        private SourceTransactionalAction transactionalAction;
        private ListenerQualityOfService qualityOfService;
        private MuleContext muleContext;

        public Builder withNumberOfConsumers(int numberOfConsumers) {
            this.numberOfConsumers = numberOfConsumers;
            return this;
        }

        public Builder withAckMode(InternalAckMode ackMode) {
            this.ackMode = ackMode;
            return this;
        }

        public Builder withConnection(AmqpTransactionalConnection connection) {
            this.connection = connection;
            return this;
        }

        public Builder withQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder withNoLocal(boolean noLocal) {
            this.noLocal = noLocal;
            return this;
        }

        public Builder withExclusiveConsumers(boolean exclusiveConsumers) {
            this.exclusiveConsumers = exclusiveConsumers;
            return this;
        }

        public Builder withConsumerTag(String consumerTag) {
            this.consumerTag = consumerTag;
            return this;
        }

        public Builder withSourceCallback(SourceCallback<InputStream, AmqpAttributes> sourceCallback) {
            this.sourceCallback = sourceCallback;
            return this;
        }

        public Builder withInboundEncoding(String inboundEncoding) {
            this.inboundEncoding = inboundEncoding;
            return this;
        }

        public Builder withConfigEncoding(String configEncoding) {
            this.configEncoding = configEncoding;
            return this;
        }

        public Builder withInboundContentType(String inboundContentType) {
            this.inboundContentType = inboundContentType;
            return this;
        }

        public Builder withConfigContentType(String configContentType) {
            this.configContentType = configContentType;
            return this;
        }

        public Builder withChannelManager(AmqpChannelManager channelManager) {
            this.channelManager = channelManager;
            return this;
        }

        public Builder withTransactionalAction(SourceTransactionalAction transactionalAction) {
            this.transactionalAction = transactionalAction;
            return this;
        }

        public Builder withMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
            return this;
        }

        public Builder withQualityOfService(ListenerQualityOfService qualityOfService) {
            this.qualityOfService = qualityOfService;
            return this;
        }

        public MultiChannelReceiverManager build() {
            return new MultiChannelReceiverManager(this.numberOfConsumers, this.connection, this.ackMode, this.queueName, this.noLocal, this.exclusiveConsumers, this.consumerTag, this.sourceCallback, this.inboundEncoding, this.configEncoding, this.inboundContentType, this.configContentType, this.channelManager, this.transactionalAction, this.qualityOfService, this.muleContext);
        }
    }
}

