/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.operation;

import com.mule.extensions.amqp.api.exception.AmqpAckException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpRejectErrorTypeProvider;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import javax.inject.Inject;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmqpReject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpReject.class);
    @Inject
    private AmqpChannelManager channelManager;

    @Throws(value={AmqpRejectErrorTypeProvider.class})
    public void reject(@Summary(value="Deliver Tag of the message to be rejected") String ackId, @Summary(value="Indicates whether the rejected message has to be requeued") boolean requeue) throws AmqpExtensionException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [reject] for message : [" + ackId + "]");
            }
            this.channelManager.reject(ackId, requeue);
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while rejecting  a message with ackId: %s", ackId, e.getMessage());
            throw new AmqpAckException(msg, e);
        }
    }
}

