/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.publisher;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherReturnHandlerListener
implements ReturnListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherReturnHandlerListener.class);
    private String returnMessageExchange;
    private Channel channel;

    public DispatcherReturnHandlerListener(String returnMessageExchange, Channel channel) {
        this.returnMessageExchange = returnMessageExchange;
        this.channel = channel;
    }

    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String errorMessage = String.format("AMQP returned message with code: %d, reason: %s, exchange: %s, routing key: %s", replyCode, replyText, exchange, routingKey);
        LOGGER.error(errorMessage);
        this.channel.basicPublish(this.returnMessageExchange, "", properties, body);
    }
}

