/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.entity;

import com.mule.extensions.amqp.api.exception.AmqpQueueNotFoundException;
import com.mule.extensions.amqp.api.model.QueueDefinition;
import com.mule.extensions.amqp.internal.entity.AmqpDeclarationException;
import com.mule.extensions.amqp.internal.entity.AmqpDeclarer;
import com.mule.extensions.amqp.internal.exception.resolver.ConsumeExceptionResolver;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpQueueDeclarer
implements AmqpDeclarer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpQueueDeclarer.class);
    private Channel channel;
    private QueueDefinition queueDefinition;
    private String queueName;
    private ConsumeExceptionResolver exceptionResolver = new ConsumeExceptionResolver();

    public AmqpQueueDeclarer(Channel channel, QueueDefinition queueDefinition, String queueName) {
        this.channel = channel;
        this.queueDefinition = queueDefinition;
        this.queueName = queueName;
    }

    @Override
    public void declarePassive() throws AmqpDeclarationException {
        try {
            this.channel.queueDeclarePassive(this.queueName);
        }
        catch (IOException e) {
            throw new AmqpDeclarationException("Error during active declaration of queue " + this.queueName + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void declareActive() throws AmqpDeclarationException {
        try {
            this.channel.queueDeclare(this.queueName, this.queueDefinition.getRemovalStrategy().isDurable(), false, this.queueDefinition.getRemovalStrategy().isAutoDelete(), new HashMap());
            if (this.queueDefinition.getExchangeToBind() != null) {
                this.channel.queueBind(this.queueName, this.queueDefinition.getExchangeToBind(), this.queueName);
            }
        }
        catch (IOException e) {
            throw new AmqpDeclarationException("Error during active declaration of queue " + this.queueName + ":" + e.getMessage(), e);
        }
    }

    public boolean queueExists() throws IOException {
        try {
            this.channel.queueDeclarePassive(this.queueName);
        }
        catch (IOException e) {
            if (this.exceptionResolver.resolveException(e) instanceof AmqpQueueNotFoundException) {
                return false;
            }
            throw e;
        }
        LOGGER.debug("Validated presence of queue: " + this.queueName);
        return true;
    }
}

