/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.exception.resolver.ExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;

public abstract class ShutdownSignalExceptionResolver
implements ExceptionResolver {
    public static final String CHANNEL_CLOSE = "channel.close";

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        int replyCode;
        if (this.reasonIsChannelClose(throwable) && (replyCode = this.getReplyCode((ShutdownSignalException)throwable)) == 404) {
            return this.getResourceNotFoundException(throwable.getMessage());
        }
        return new AmqpExtensionException(throwable.getMessage());
    }

    abstract AmqpExtensionException getResourceNotFoundException(String var1);

    protected boolean reasonIsChannelClose(Throwable throwable) {
        if (throwable instanceof ShutdownSignalException) {
            ShutdownSignalException exception = (ShutdownSignalException)throwable;
            return exception.getReason() != null && exception.getReason().protocolMethodName().equals(CHANNEL_CLOSE);
        }
        return false;
    }

    protected int getReplyCode(ShutdownSignalException exception) {
        return ((AMQImpl.Channel.Close)exception.getReason()).getReplyCode();
    }
}

