/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.source;

import com.mule.extensions.amqp.internal.source.AmqpListenerLock;
import java.util.concurrent.Semaphore;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;

public class DefaultAmqpListenerLock
implements AmqpListenerLock {
    private Semaphore semaphore = new Semaphore(1);
    private boolean isFailure = false;
    private Throwable cause;

    @Override
    public void lock() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The AMQP Listener Lock has been interrupted."), this.cause);
        }
        if (this.isFailure) {
            throw new MuleRuntimeException(this.cause);
        }
    }

    @Override
    public void unlockWithFailure(Error error) {
        this.isFailure = true;
        this.cause = error.getCause();
        this.releaseIfNecessary();
    }

    @Override
    public void unlockWithFailure() {
        this.isFailure = true;
        this.cause = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The AMQP Lock has been unlocked indicating that a channel recover should be executed."));
        this.releaseIfNecessary();
    }

    @Override
    public void unlock() {
        this.isFailure = false;
        this.releaseIfNecessary();
    }

    @Override
    public boolean isLocked() {
        return this.semaphore.availablePermits() == 0;
    }

    private void releaseIfNecessary() {
        if (this.isLocked()) {
            this.semaphore.release();
        }
    }
}

