/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection;

import com.mule.extensions.amqp.internal.config.InternalAckMode;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.consumer.AmqpMessageConsumer;
import com.mule.extensions.amqp.internal.consumer.DefaultAmqpMessageConsumer;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnection
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConnection.class);
    protected Connection connection;
    @Inject
    private AmqpChannelManager amqpChannelManager;

    public AmqpConnection(Connection connection) {
        this.connection = connection;
    }

    public Channel createChannel() throws IOException {
        return this.connection.createChannel();
    }

    public AmqpMessageConsumer createConsumer(Channel channel, String queue, long timeout, InternalAckMode ackMode) {
        return new DefaultAmqpMessageConsumer(channel, queue, timeout, ackMode, null);
    }

    public AmqpMessageConsumer createConsumer(Channel channel, String queue, long timeout, String consumerTag, InternalAckMode ackMode) {
        return new DefaultAmqpMessageConsumer(channel, queue, timeout, ackMode, consumerTag);
    }

    public void dispose() {
        block3: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing AMQP Connection: " + this.connection);
            }
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (IOException ex) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Error disposing AMQP connection: ", (Throwable)ex);
            }
        }
    }

    protected AmqpChannelManager getAmqpChannelManager() {
        return this.amqpChannelManager;
    }
}

