/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.common;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.config.QualityOfService;
import com.mule.extensions.amqp.api.exception.AmqpCreationNotAllowedException;
import com.mule.extensions.amqp.api.exception.AmqpExchangeNotFoundException;
import com.mule.extensions.amqp.api.model.ExchangeDefinition;
import com.mule.extensions.amqp.api.model.Properties;
import com.mule.extensions.amqp.internal.config.AmqpAckMode;
import com.mule.extensions.amqp.internal.config.InternalAckMode;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.connection.channel.MuleAmqpChannel;
import com.mule.extensions.amqp.internal.connection.channel.TransactionStatus;
import com.mule.extensions.amqp.internal.entity.AmqpExchangeDeclarer;
import com.mule.extensions.amqp.internal.message.AmqpMessage;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpCommons.class);
    public static final String EXAMPLE_ENCODING = "UTF-8";
    public static final String EXAMPLE_CONTENT_TYPE = "application/json";

    public static String resolveMessageContentType(String contentType, String defaultType) {
        return StringUtils.isBlank((CharSequence)contentType) ? defaultType : contentType;
    }

    public static String getMessageAckId(Channel channel, long deliveryTag) {
        return deliveryTag + "-" + channel.getChannelNumber();
    }

    public static String resolveMessageEncoding(String contentType, String defaultType) {
        return StringUtils.isBlank((CharSequence)contentType) ? defaultType : contentType;
    }

    public static String getChannelDeliveryTagId(int numberOfChannel, String deliveryTag) {
        return numberOfChannel + "_" + deliveryTag;
    }

    public static MuleAmqpChannel declareFallbackExchangeIfNeeded(AmqpTransactionalConnection connection, String exchangeName, ExchangeDefinition fallbackExchangeDefinition, OperationTransactionalAction transactionalAction, MuleAmqpChannel channel, AmqpChannelManager channelManager, boolean createFallbackExchange) throws IOException {
        AmqpExchangeDeclarer exchangeDeclarer = new AmqpExchangeDeclarer(channel, fallbackExchangeDefinition, exchangeName);
        boolean existingExchange = exchangeDeclarer.exchangeExists();
        if (fallbackExchangeDefinition != null && !createFallbackExchange && !existingExchange) {
            throw new AmqpCreationNotAllowedException("Creation not allowed for exchange: " + exchangeName + ". Set createFallbackExchange to true or create the exchange.");
        }
        if (!(fallbackExchangeDefinition != null && createFallbackExchange || existingExchange)) {
            throw new AmqpExchangeNotFoundException("Exchange was not found.");
        }
        if (fallbackExchangeDefinition != null && !existingExchange) {
            channel = AmqpCommons.createAmqpChannel(connection, channelManager, transactionalAction);
            exchangeDeclarer = new AmqpExchangeDeclarer(channel, fallbackExchangeDefinition, exchangeName);
            exchangeDeclarer.declareActive();
        }
        return channel;
    }

    public static String resolveReturnedMessageExchange(String returnedMessageExchangeFromConfig, String override) {
        return override != null ? override : returnedMessageExchangeFromConfig;
    }

    public static MuleAmqpChannel createAmqpChannel(AmqpTransactionalConnection connection, AmqpChannelManager channelManager, OperationTransactionalAction transactionalAction) throws IOException {
        return AmqpCommons.createAmqpChannel(connection, channelManager, transactionalAction, null);
    }

    public static void evaluateMessageAck(Channel channel, AmqpMessage message, AmqpChannelManager channelManager, InternalAckMode ackMode, String ackId) throws IOException {
        if (ackMode.equals((Object)InternalAckMode.TRANSACTED)) {
            LOGGER.debug("Automatically performing an ACK over the message, since AckMode was IMMEDIATE");
            channel.basicAck(message.getEnvelope().getDeliveryTag(), false);
        } else if (ackMode.equals((Object)InternalAckMode.MANUAL)) {
            channelManager.registerMessageForAck(ackId, message, channel);
        }
    }

    public static InternalAckMode toInternalAckMode(AmqpAckMode ackMode) {
        return ackMode == null ? null : ackMode.getInternalAckMode();
    }

    public static <T> T resolveOverride(T configValue, T operationValue) {
        return operationValue == null ? configValue : operationValue;
    }

    public static MuleAmqpChannel createAmqpChannel(AmqpTransactionalConnection connection, AmqpChannelManager channelManager, OperationTransactionalAction transactionalAction, QualityOfService qualityOfService) throws IOException {
        return !transactionalAction.equals((Object)OperationTransactionalAction.NOT_SUPPORTED) ? new MuleAmqpChannel(AmqpCommons.getOrCreateTransactedChannel(connection, channelManager, channelManager.getTransactedChannel()), !channelManager.getTransactionStatus().equals((Object)TransactionStatus.NONE)) : AmqpCommons.createNewChannel(connection, qualityOfService);
    }

    private static MuleAmqpChannel createNewChannel(AmqpTransactionalConnection connection, QualityOfService qualityOfService) throws IOException {
        Channel channel = connection.createChannel();
        if (qualityOfService != null) {
            channel.basicQos(qualityOfService.getPrefetchSize(), qualityOfService.getPrefetchCount(), false);
        }
        return new MuleAmqpChannel(channel, false);
    }

    public static void closeQuietly(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close amqp connection resource: ", (Throwable)e);
            }
        }
    }

    public static void releaseChannelIfNeeded(MuleAmqpChannel channel) {
        if (!channel.isInTransaction()) {
            AmqpCommons.closeQuietly(channel);
        }
    }

    public static String resolveMessageContentType(AmqpMessage message, String defaultType) {
        String contentType = message.getProperties().getContentType();
        return StringUtils.isBlank((CharSequence)contentType) ? defaultType : contentType;
    }

    public static String resolveMessageEncoding(AmqpMessage message, String defaultEncoding) {
        String contentEncoding = message.getProperties().getContentEncoding();
        return StringUtils.isBlank((CharSequence)contentEncoding) ? defaultEncoding : contentEncoding;
    }

    public static Channel getOrCreateTransactedChannel(AmqpTransactionalConnection connection, AmqpChannelManager channelManager, Optional<Channel> transactedChannel) throws IOException {
        Channel channel;
        if (transactedChannel.isPresent()) {
            channel = transactedChannel.get();
        } else {
            switch (channelManager.getTransactionStatus()) {
                case STARTED: {
                    channel = connection.createChannel();
                    channel.txSelect();
                    channelManager.bindToTransaction(channel);
                    break;
                }
                default: {
                    channel = connection.createChannel();
                }
            }
        }
        return channel;
    }

    public static Properties getPropertiesFromBasicProperties(AMQP.BasicProperties properties) {
        Properties.Builder builder = new Properties.Builder().withAppId(properties.getAppId()).withClusterId(properties.getClusterId()).withContentEncoding(properties.getContentEncoding()).withContentType(properties.getContentType()).withCorrelationId(properties.getCorrelationId()).withDeliveryMode(properties.getDeliveryMode() == null ? null : DeliveryMode.fromCode(properties.getDeliveryMode())).withMessageId(properties.getMessageId()).withPriority(properties.getPriority()).withReplyTo(properties.getReplyTo()).withTimestamp(properties.getTimestamp()).withType(properties.getType()).withUserid(properties.getUserId());
        return builder.build();
    }
}

