/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.provider;

import com.mule.extensions.amqp.internal.connection.AmqpConnection;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.param.GenericConnectionParameters;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.SslContextFactory;
import com.rabbitmq.client.SslEngineConfigurator;
import com.rabbitmq.client.impl.nio.NioParams;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.net.SocketFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="connection")
public class GenericConnectionProvider
implements CachedConnectionProvider<AmqpTransactionalConnection>,
Initialisable,
Disposable {
    private static final String TLS_CONFIGURATION = "TLS Configuration";
    private static final Integer PLAIN_CONNECTION_PORT = 5672;
    private static final Integer SECURE_CONNECTION_PORT = 5671;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericConnectionProvider.class);
    @ParameterGroup(name="Connection")
    private GenericConnectionParameters connectionParameters;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    private ConnectionFactory connectionFactory;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    public AmqpTransactionalConnection connect() throws ConnectionException {
        try {
            this.connectionFactory.setUsername(this.connectionParameters.getUsername());
            this.connectionFactory.setPassword(this.connectionParameters.getPassword());
            this.connectionFactory.setRequestedHeartbeat(this.connectionParameters.getHeartbeatTimeout());
            Connection connection = this.connectionFactory.newConnection((ExecutorService)this.scheduler);
            return new AmqpTransactionalConnection(connection);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), e.getCause());
        }
    }

    public void disconnect(AmqpTransactionalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disconnection Started");
        }
        this.doStop(connection);
        this.doClose(connection);
    }

    public ConnectionValidationResult validate(AmqpTransactionalConnection connection) {
        try {
            Channel channel = connection.createChannel();
            channel.close();
        }
        catch (Exception e) {
            ConnectionValidationResult.failure((String)"Error validating AMQP connection", (Exception)e);
        }
        return ConnectionValidationResult.success();
    }

    public void dispose() {
        this.connectionFactory = null;
        this.shutdownScheduler();
    }

    private void shutdownScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.connectionParameters.isUseTls() && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured without setting useTls. If you defined a tls:context element in your connection configuration then you must set useTls"), (Initialisable)this);
        }
        if (this.connectionParameters.isUseTls() && this.tlsContext == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"useTls is set but there's no TlsContext configured"), (Initialisable)this);
        }
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        if (this.connectionParameters.isUseSni() && !this.connectionParameters.isUseTls()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"SNI can only be set using a TLS Context"), (Initialisable)this);
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        this.scheduler = this.schedulerService.ioScheduler();
        this.initialiseConnectionFactory();
        if (this.tlsContext != null) {
            try {
                this.setSocketFactory();
                this.setSslContext();
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Error while creating socket factory."), (Initialisable)this);
            }
        }
    }

    private void setSslContext() throws KeyManagementException, NoSuchAlgorithmException {
        final SSLContext sslContext = this.tlsContext.createSslContext();
        this.connectionFactory.setSslContextFactory(new SslContextFactory(){

            public SSLContext create(String name) {
                return sslContext;
            }
        });
    }

    private void setSocketFactory() throws Exception {
        this.connectionFactory.setSocketFactory((SocketFactory)this.tlsContext.createSocketFactory());
    }

    private void initialiseConnectionFactory() {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.connectionParameters.getHost());
        this.setConnectionFactoryPort();
        this.connectionFactory.setVirtualHost(this.connectionParameters.getVirtualHost());
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.useNio();
        NioParams nioParams = new NioParams();
        if (this.connectionParameters.isUseSni()) {
            nioParams.setSslEngineConfigurator(new SslEngineConfigurator(){

                public void configure(SSLEngine sslEngine) throws IOException {
                    SSLParameters parameters = sslEngine.getSSLParameters();
                    ArrayList<SNIServerName> servers = new ArrayList<SNIServerName>();
                    servers.add(new SNIHostName(GenericConnectionProvider.this.connectionFactory.getHost()));
                    parameters.setServerNames(servers);
                    sslEngine.setSSLParameters(parameters);
                }
            });
        }
        nioParams.setNioExecutor((ExecutorService)this.scheduler);
        this.connectionFactory.setNioParams(nioParams);
    }

    private void setConnectionFactoryPort() {
        if (this.connectionParameters.getPort() != null) {
            this.connectionFactory.setPort(this.connectionParameters.getPort().intValue());
        } else if (this.connectionParameters.isUseTls()) {
            this.connectionFactory.setPort(SECURE_CONNECTION_PORT.intValue());
        } else {
            this.connectionFactory.setPort(PLAIN_CONNECTION_PORT.intValue());
        }
    }

    protected void doStop(AmqpConnection amqpConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doStop: [%s]", this.getClass().getName()));
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)amqpConnection);
        }
        catch (Exception e) {
            LOGGER.warn("Jms connection failed to stop properly: ", (Throwable)e);
        }
    }

    protected void doClose(AmqpConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doClose: [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
    }
}

