/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.message;

import com.mule.extensions.amqp.api.message.AmqpAttributes;
import com.mule.extensions.amqp.api.message.Envelope;
import com.mule.extensions.amqp.internal.message.AmqpMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpResultFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpResultFactory.class);

    public Result<InputStream, AmqpAttributes> createResult(AmqpMessage amqpMessage, String contentType, String encoding, String ackId) {
        if (amqpMessage == null) {
            LOGGER.debug("Resulting AMQP Message was [null], creating an empty result");
            return this.createEmptyResult();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Creating Result: contentType:[%s], encoding:[%s]", contentType, encoding));
        }
        return Result.builder().output((Object)new ByteArrayInputStream(amqpMessage.getBody())).mediaType(this.getMediaType(contentType, encoding)).attributes((Object)this.createAmqpAttributes(amqpMessage, ackId)).build();
    }

    private MediaType getMediaType(String contentType, String encoding) {
        DataTypeParamsBuilder builder = DataType.builder().mediaType(contentType);
        if (encoding != null) {
            builder.charset(Charset.forName(encoding));
        }
        return builder.build().getMediaType();
    }

    private AmqpAttributes createAmqpAttributes(AmqpMessage message, String ackId) {
        AmqpAttributes.Builder builder = AmqpAttributes.Builder.newInstance().withProperties(message.getProperties()).withAckId(ackId).withHeaders(message.getHeaders()).withEnvelope(new Envelope(message.getEnvelope().getDeliveryTag(), message.getEnvelope().isRedeliver(), message.getEnvelope().getExchange(), message.getEnvelope().getRoutingKey()));
        return builder.build();
    }

    public Result<InputStream, AmqpAttributes> createEmptyResult() {
        return Result.builder().output(null).build();
    }
}

