/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpConsumeTimeoutException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpQueueNotFoundException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import org.mule.runtime.api.connection.ConnectionException;

public class ConsumeShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    public static final String TIMEOUT_SIGNAL_MESSAGE = "A timeout was sent by the broker";

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        if (this.reasonIsChannelClose(throwable)) {
            int replyCode = this.getReplyCode((ShutdownSignalException)throwable);
            if (replyCode == 408) {
                return new AmqpConsumeTimeoutException(TIMEOUT_SIGNAL_MESSAGE);
            }
            return super.resolveException(throwable);
        }
        if (this.reasonIsConnectionClose(throwable)) {
            return new AmqpExtensionException("Connectivity Error", (Exception)new ConnectionException(throwable, null));
        }
        return new AmqpExtensionException(throwable.getMessage());
    }

    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpQueueNotFoundException(message);
    }
}

